/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class LogSilencer {
    public static final String SILENCING_POSTFIX = " (similar log silenced for a while)";
    private static final long DEFAULT_SILENCE_MILLIS = Duration.ofMinutes(15L).toMillis();
    private static final int DEFAULT_CACHE_SIZE = 64;
    private final int cacheSize;
    private final long silenceMillis;
    private final Map<String, Long> silences = Collections.synchronizedMap(new LinkedHashMap<String, Long>(){

        @Override
        protected final boolean removeEldestEntry(Map.Entry<String, Long> eldest) {
            return this.size() > LogSilencer.this.cacheSize;
        }
    });

    public LogSilencer() {
        this(DEFAULT_SILENCE_MILLIS, 64);
    }

    public LogSilencer(long silenceMillis, int cacheSize) {
        if (cacheSize <= 0) {
            throw new IllegalArgumentException("cacheSize must be > 0, is: " + cacheSize);
        }
        this.silenceMillis = silenceMillis;
        this.cacheSize = cacheSize;
    }

    public final boolean silence(String key) {
        Long approxNow = System.currentTimeMillis();
        Long prevOrNull = this.silences.putIfAbsent(key, approxNow);
        if (prevOrNull == null) {
            return false;
        }
        if (this.silenceMillis < 0L) {
            return true;
        }
        if (approxNow <= prevOrNull + this.silenceMillis) {
            return true;
        }
        this.silences.put(key, approxNow);
        return false;
    }
}

