/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.util.BiStatsConsumer;
import org.apache.jackrabbit.oak.plugins.document.util.TriStatsConsumer;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

public final class CreateMetricUpdater {
    private final MeterStats createNodeMeter;
    private final MeterStats createSplitNodeMeter;
    private final TimerStats createNodeTimer;
    private final MeterStats createJournal;
    private final TimerStats createJournalTimer;

    public CreateMetricUpdater(MeterStats createNodeMeter, MeterStats createSplitNodeMeter, TimerStats createNodeTimer, MeterStats createJournal, TimerStats createJournalTimer) {
        this.createNodeMeter = createNodeMeter;
        this.createSplitNodeMeter = createSplitNodeMeter;
        this.createNodeTimer = createNodeTimer;
        this.createJournal = createJournal;
        this.createJournalTimer = createJournalTimer;
    }

    public void update(Collection<? extends Document> collection, long timeTakenNanos, List<String> ids, boolean insertSuccess, BiPredicate<Collection<? extends Document>, Integer> isNodesCollectionUpdated, TriStatsConsumer triStatsConsumer, Predicate<Collection<? extends Document>> isJournalCollection, BiStatsConsumer journalBiStatsConsumer) {
        Objects.requireNonNull(isNodesCollectionUpdated);
        Objects.requireNonNull(isJournalCollection);
        Objects.requireNonNull(triStatsConsumer);
        Objects.requireNonNull(journalBiStatsConsumer);
        if (isNodesCollectionUpdated.test(collection, ids.size()) && insertSuccess) {
            triStatsConsumer.accept(this.createNodeMeter, this.createSplitNodeMeter, this.createNodeTimer, ids, timeTakenNanos);
        } else if (isJournalCollection.test(collection)) {
            journalBiStatsConsumer.accept(this.createJournal, this.createJournalTimer, ids.size(), timeTakenNanos);
        }
    }
}

