/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.whiteboard;

import java.util.List;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.user.UserAuthenticationFactory;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WhiteboardUserAuthenticationFactory
extends AbstractServiceTracker<UserAuthenticationFactory>
implements UserAuthenticationFactory {
    private final UserAuthenticationFactory defaultFactory;

    public WhiteboardUserAuthenticationFactory(@Nullable UserAuthenticationFactory defaultFactory) {
        super(UserAuthenticationFactory.class);
        this.defaultFactory = defaultFactory;
    }

    @Nullable
    public Authentication getAuthentication(@NotNull UserConfiguration userConfiguration, @NotNull Root root, @Nullable String userId) {
        List services = this.getServices();
        if (services.isEmpty() && this.defaultFactory != null) {
            return this.defaultFactory.getAuthentication(userConfiguration, root, userId);
        }
        for (UserAuthenticationFactory factory : services) {
            Authentication authentication = factory.getAuthentication(userConfiguration, root, userId);
            if (authentication == null) continue;
            return authentication;
        }
        return null;
    }
}

