/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.server;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.standby.server.StandbySegmentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultStandbySegmentReader
implements StandbySegmentReader {
    private static final Logger log = LoggerFactory.getLogger(DefaultStandbySegmentReader.class);
    private final FileStore store;

    DefaultStandbySegmentReader(FileStore store) {
        this.store = store;
    }

    @Override
    public byte[] readSegment(String id) {
        UUID uuid = UUID.fromString(id);
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        SegmentId segmentId = this.store.getSegmentIdProvider().newSegmentId(msb, lsb);
        if (this.store.containsSegment(segmentId)) {
            byte[] byArray;
            Segment segment = this.store.readSegment(segmentId);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                segment.writeTo((OutputStream)stream);
                byArray = stream.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.warn("Error while reading segment content", (Throwable)e);
                    return null;
                }
            }
            stream.close();
            return byArray;
        }
        return null;
    }
}

