/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.tar.index;

import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.file.tar.index.IndexEntry;

class IndexEntryV1
implements IndexEntry {
    static final int SIZE = 28;
    private final Buffer index;
    private final int position;

    IndexEntryV1(Buffer index, int position) {
        this.index = index;
        this.position = position;
    }

    @Override
    public long getMsb() {
        return this.index.getLong(this.position);
    }

    @Override
    public long getLsb() {
        return this.index.getLong(this.position + 8);
    }

    @Override
    public int getPosition() {
        return this.index.getInt(this.position + 16);
    }

    @Override
    public int getLength() {
        return this.index.getInt(this.position + 20);
    }

    @Override
    public int getGeneration() {
        return this.index.getInt(this.position + 24);
    }

    @Override
    public int getFullGeneration() {
        return this.getGeneration();
    }

    @Override
    public boolean isCompacted() {
        return true;
    }
}

