/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.guava.common.collect.Queues;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.RecordUsageAnalyser;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class DebugStore {
    private final File path;

    public static Builder builder() {
        return new Builder();
    }

    private DebugStore(Builder builder) {
        this.path = builder.path;
    }

    public int run() {
        ReadOnlyFileStore store = Utils.openReadOnlyFileStore(this.path);
        try {
            DebugStore.debugFileStore(store);
            int n = 0;
            if (store != null) {
                store.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (store != null) {
                    try {
                        store.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
    }

    private static List<SegmentId> getReferencedSegmentIds(ReadOnlyFileStore store, Segment segment) {
        ArrayList<SegmentId> result = new ArrayList<SegmentId>();
        for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
            UUID uuid = segment.getReferencedSegmentId(i);
            long msb = uuid.getMostSignificantBits();
            long lsb = uuid.getLeastSignificantBits();
            result.add(store.getSegmentIdProvider().newSegmentId(msb, lsb));
        }
        return result;
    }

    private static void debugFileStore(ReadOnlyFileStore store) {
        HashMap idmap = Maps.newHashMap();
        int dataCount = 0;
        long dataSize = 0L;
        int bulkCount = 0;
        long bulkSize = 0L;
        RecordUsageAnalyser analyser = new RecordUsageAnalyser(store.getReader());
        for (SegmentId id : store.getSegmentIds()) {
            if (id.isDataSegmentId()) {
                Segment segment = id.getSegment();
                ++dataCount;
                dataSize += (long)segment.size();
                idmap.put(id, DebugStore.getReferencedSegmentIds(store, segment));
                DebugStore.analyseSegment(segment, analyser);
                continue;
            }
            if (!id.isBulkSegmentId()) continue;
            ++bulkCount;
            bulkSize += (long)id.getSegment().size();
            idmap.put(id, Collections.emptyList());
        }
        System.out.println("Total size:");
        System.out.format("%s in %6d data segments%n", FileUtils.byteCountToDisplaySize((long)dataSize), dataCount);
        System.out.format("%s in %6d bulk segments%n", FileUtils.byteCountToDisplaySize((long)bulkSize), bulkCount);
        System.out.println(analyser.toString());
        HashSet garbage = Sets.newHashSet(idmap.keySet());
        ArrayDeque queue = Queues.newArrayDeque();
        queue.add(store.getRevisions().getHead().getSegmentId());
        while (!queue.isEmpty()) {
            SegmentId id = (SegmentId)queue.remove();
            if (!garbage.remove(id)) continue;
            queue.addAll((Collection)idmap.get(id));
        }
        dataCount = 0;
        dataSize = 0L;
        bulkCount = 0;
        bulkSize = 0L;
        for (SegmentId id : garbage) {
            if (id.isDataSegmentId()) {
                ++dataCount;
                dataSize += (long)id.getSegment().size();
                continue;
            }
            if (!id.isBulkSegmentId()) continue;
            ++bulkCount;
            bulkSize += (long)id.getSegment().size();
        }
        System.out.format("%nAvailable for garbage collection:%n", new Object[0]);
        System.out.format("%s in %6d data segments%n", FileUtils.byteCountToDisplaySize((long)dataSize), dataCount);
        System.out.format("%s in %6d bulk segments%n", FileUtils.byteCountToDisplaySize((long)bulkSize), bulkCount);
    }

    private static void analyseSegment(Segment segment, RecordUsageAnalyser analyser) {
        ArrayList ids = Lists.newArrayList();
        segment.forEachRecord((number, type, offset) -> {
            if (type == RecordType.NODE) {
                ids.add(new RecordId(segment.getSegmentId(), number));
            }
        });
        for (RecordId id : ids) {
            try {
                analyser.analyseNode(id);
            }
            catch (Exception e) {
                System.err.format("Error while processing node at %s", id);
                e.printStackTrace(System.err);
            }
        }
    }

    public static class Builder {
        private File path;

        private Builder() {
        }

        public Builder withPath(File path) {
            this.path = (File)Preconditions.checkNotNull((Object)path);
            return this;
        }

        public DebugStore build() {
            Preconditions.checkNotNull((Object)this.path);
            return new DebugStore(this);
        }
    }
}

