/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Charsets;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.blob.BlobStoreBlob;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.plugins.memory.AbstractBlob;
import org.apache.jackrabbit.oak.segment.ListRecord;
import org.apache.jackrabbit.oak.segment.Record;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentStream;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SegmentBlob
extends Record
implements Blob {
    @Nullable
    private final BlobStore blobStore;

    public static Iterable<SegmentId> getBulkSegmentIds(Blob blob) {
        if (blob instanceof SegmentBlob) {
            return ((SegmentBlob)blob).getBulkSegmentIds();
        }
        return Collections.emptySet();
    }

    SegmentBlob(@Nullable BlobStore blobStore, @NotNull RecordId id) {
        super(id);
        this.blobStore = blobStore;
    }

    private InputStream getInlineStream(Segment segment, int offset, int length) {
        return new SegmentStream(this.getRecordId(), segment.readBytes(this.getRecordNumber(), offset, length), length);
    }

    @NotNull
    public InputStream getNewStream() {
        Segment segment = this.getSegment();
        byte head = segment.readByte(this.getRecordNumber());
        if ((head & 0x80) == 0) {
            return this.getInlineStream(segment, 1, head);
        }
        if ((head & 0xC0) == 128) {
            int length = (segment.readShort(this.getRecordNumber()) & 0x3FFF) + 128;
            return this.getInlineStream(segment, 2, length);
        }
        if ((head & 0xE0) == 192) {
            long length = (segment.readLong(this.getRecordNumber()) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
            int listSize = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(segment.readRecordId(this.getRecordNumber(), 8), listSize);
            return new SegmentStream(this.getRecordId(), list, length);
        }
        if ((head & 0xF0) == 224) {
            return this.getNewStream(SegmentBlob.readShortBlobId(segment, this.getRecordNumber(), head));
        }
        if ((head & 0xF8) == 240) {
            return this.getNewStream(SegmentBlob.readLongBlobId(segment, this.getRecordNumber()));
        }
        throw new IllegalStateException(String.format("Unexpected value record type: %02x", head & 0xFF));
    }

    public long length() {
        Segment segment = this.getSegment();
        byte head = segment.readByte(this.getRecordNumber());
        if ((head & 0x80) == 0) {
            return head;
        }
        if ((head & 0xC0) == 128) {
            return (segment.readShort(this.getRecordNumber()) & 0x3FFF) + 128;
        }
        if ((head & 0xE0) == 192) {
            return (segment.readLong(this.getRecordNumber()) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
        }
        if ((head & 0xF0) == 224) {
            return this.getLength(SegmentBlob.readShortBlobId(segment, this.getRecordNumber(), head));
        }
        if ((head & 0xF8) == 240) {
            return this.getLength(SegmentBlob.readLongBlobId(segment, this.getRecordNumber()));
        }
        throw new IllegalStateException(String.format("Unexpected value record type: %02x", head & 0xFF));
    }

    @Nullable
    public String getReference() {
        String blobId = this.getBlobId();
        if (blobId != null) {
            if (this.blobStore != null) {
                return this.blobStore.getReference(blobId);
            }
            throw new IllegalStateException("Attempt to read external blob with blobId [" + blobId + "] without specifying BlobStore");
        }
        return null;
    }

    public String getContentIdentity() {
        String blobId = this.getBlobId();
        if (blobId != null) {
            return blobId;
        }
        return null;
    }

    public boolean isInlined() {
        return this.isExternal() && InMemoryDataRecord.isInstance((String)this.getBlobId());
    }

    public boolean isExternal() {
        Segment segment = this.getSegment();
        byte head = segment.readByte(this.getRecordNumber());
        return (head & 0xF0) == 224 || (head & 0xF8) == 240;
    }

    @Nullable
    public String getBlobId() {
        return SegmentBlob.readBlobId(this.getSegment(), this.getRecordNumber());
    }

    @Nullable
    public static String readBlobId(@NotNull Segment segment, int recordNumber) {
        byte head = segment.readByte(recordNumber);
        if ((head & 0xF0) == 224) {
            return SegmentBlob.readShortBlobId(segment, recordNumber, head);
        }
        if ((head & 0xF8) == 240) {
            return SegmentBlob.readLongBlobId(segment, recordNumber);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (Record.fastEquals((Object)this, object)) {
            return true;
        }
        if (object instanceof SegmentBlob) {
            SegmentBlob that = (SegmentBlob)object;
            if (this.blobStore == null) {
                if (this.getContentIdentity() != null && that.getContentIdentity() != null) {
                    return this.getContentIdentity().equals(that.getContentIdentity());
                }
                if (this.isExternal() && !that.isExternal() || !this.isExternal() && that.isExternal()) {
                    return false;
                }
            }
            if (this.length() != that.length()) {
                return false;
            }
            List<RecordId> bulkIds = this.getBulkRecordIds();
            if (bulkIds != null && bulkIds.equals(that.getBulkRecordIds())) {
                return true;
            }
        }
        return object instanceof Blob && AbstractBlob.equal((Blob)this, (Blob)((Blob)object));
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static String readShortBlobId(Segment segment, int recordNumber, byte head) {
        int length = (head & 0xF) << 8 | segment.readByte(recordNumber, 1) & 0xFF;
        return segment.readBytes(recordNumber, 2, length).decode(Charsets.UTF_8).toString();
    }

    private static String readLongBlobId(Segment segment, int recordNumber) {
        RecordId blobId = segment.readRecordId(recordNumber, 1);
        return blobId.getSegment().readString(blobId.getRecordNumber());
    }

    private List<RecordId> getBulkRecordIds() {
        Segment segment = this.getSegment();
        byte head = segment.readByte(this.getRecordNumber());
        if ((head & 0xE0) == 192) {
            long length = (segment.readLong(this.getRecordNumber()) & 0x1FFFFFFFFFFFFFFFL) + 16512L;
            int listSize = (int)((length + 4096L - 1L) / 4096L);
            ListRecord list = new ListRecord(segment.readRecordId(this.getRecordNumber(), 8), listSize);
            return list.getEntries();
        }
        return null;
    }

    private Iterable<SegmentId> getBulkSegmentIds() {
        List<RecordId> recordIds = this.getBulkRecordIds();
        if (recordIds == null) {
            return Collections.emptySet();
        }
        HashSet ids = Sets.newHashSet();
        for (RecordId id : recordIds) {
            ids.add(id.getSegmentId());
        }
        return ids;
    }

    private Blob getBlob(String blobId) {
        if (this.blobStore != null) {
            return new BlobStoreBlob(this.blobStore, blobId);
        }
        throw new IllegalStateException("Attempt to read external blob with blobId [" + blobId + "] without specifying BlobStore");
    }

    private InputStream getNewStream(String blobId) {
        return this.getBlob(blobId).getNewStream();
    }

    private long getLength(String blobId) {
        long length = this.getBlob(blobId).length();
        if (length == -1L) {
            throw new IllegalStateException(String.format("Unknown length of external binary: %s", blobId));
        }
        return length;
    }
}

