/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Map;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.Sweep2StatusDocument;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sweep2Helper {
    private static final Logger LOG = LoggerFactory.getLogger(Sweep2Helper.class);

    static boolean isSweep2Necessary(DocumentStore store) {
        NodeDocument rootNodeDoc = store.find(Collection.NODES, Utils.getIdFromPath("/"));
        if (rootNodeDoc == null) {
            LOG.warn("isSweep2Necessary : cannot get root node - assuming no sweep2 needed");
            return false;
        }
        if (rootNodeDoc.get("_sweepRev") == null) {
            return false;
        }
        Map<Revision, String> bcValueMap = rootNodeDoc.getValueMap("_bc");
        Map<Revision, String> valueMap = rootNodeDoc.getValueMap("_revisions");
        for (Map.Entry<Revision, String> entry : valueMap.entrySet()) {
            Revision cRev;
            Revision rev = entry.getKey();
            String cv = entry.getValue();
            if (cv == null || (cRev = Utils.resolveCommitRevision(rev, cv)).equals(rev) || bcValueMap.containsKey(rev)) continue;
            return true;
        }
        return false;
    }

    static long acquireSweep2LockIfNecessary(DocumentStore store, int clusterId) {
        Sweep2StatusDocument status = Sweep2StatusDocument.readFrom(store);
        if (status != null && status.isSwept()) {
            return -1L;
        }
        if (status == null) {
            return Sweep2StatusDocument.acquireOrUpdateSweep2Lock(store, clusterId, false);
        }
        int lockClusterId = status.getLockClusterId();
        if (lockClusterId == clusterId) {
            LOG.info("acquireSweep2LockIfNecessary : sweep2 status was sweeping, locked by own instance ({}). Another sweep2 is required.", (Object)clusterId);
            return status.getLockValue();
        }
        if (ClusterNodeInfoDocument.all(store).stream().anyMatch(info -> info.getClusterId() == lockClusterId && info.isActive())) {
            LOG.debug("acquireSweep2LockIfNecessary : another instance (id {}) is (still) busy doing a sweep2.", (Object)lockClusterId);
            return 0L;
        }
        return Sweep2StatusDocument.acquireOrUpdateSweep2Lock(store, clusterId, false);
    }
}

