/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfoDocument;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecoveryLock {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveryLock.class);
    private final DocumentStore store;
    private final Clock clock;
    private final int clusterId;

    RecoveryLock(DocumentStore store, Clock clock, int clusterId) {
        this.store = store;
        this.clock = clock;
        this.clusterId = clusterId;
    }

    boolean acquireRecoveryLock(int recoveredBy) {
        ClusterNodeInfoDocument doc = this.store.find(Collection.CLUSTER_NODES, String.valueOf(this.clusterId));
        if (doc == null) {
            return false;
        }
        if (!doc.isRecoveryNeeded(this.clock.getTime())) {
            return false;
        }
        if (this.tryAcquireRecoveryLock(doc, recoveredBy)) {
            return true;
        }
        return doc.isBeingRecoveredBy(recoveredBy) || this.tryBreakRecoveryLock(doc, recoveredBy);
    }

    void releaseRecoveryLock(boolean success) {
        try {
            UpdateOp update = new UpdateOp(Integer.toString(this.clusterId), false);
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.NONE.name());
            update.set("recoveryBy", null);
            if (success) {
                update.set("state", null);
                update.set("leaseEnd", null);
                update.set("runtime_id", null);
            } else {
                update.set("leaseEnd", this.clock.getTime() - 1L);
            }
            ClusterNodeInfoDocument old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
            if (old == null) {
                throw new DocumentStoreException("ClusterNodeInfo document for " + this.clusterId + " does not exist.");
            }
            LOG.info("Released recovery lock for cluster id {} (recovery successful: {})", (Object)this.clusterId, (Object)success);
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to release the recovery lock for clusterNodeId " + this.clusterId, (Throwable)ex);
            throw ex;
        }
    }

    private boolean tryAcquireRecoveryLock(ClusterNodeInfoDocument info, int recoveredBy) {
        int clusterId = info.getClusterId();
        try {
            ClusterNodeInfoDocument old;
            UpdateOp update = new UpdateOp(Integer.toString(clusterId), false);
            update.equals("state", ClusterNodeInfo.ClusterNodeState.ACTIVE.name());
            update.equals("leaseEnd", info.getLeaseEndTime());
            update.notEquals("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.set("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.set("leaseEnd", this.clock.getTime() + (long)ClusterNodeInfo.DEFAULT_LEASE_DURATION_MILLIS);
            if (recoveredBy != 0) {
                update.set("recoveryBy", recoveredBy);
            }
            if ((old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update)) != null) {
                LOG.info("Acquired recovery lock for cluster id {}", (Object)clusterId);
            }
            return old != null;
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to acquire the recovery lock for clusterNodeId " + clusterId, (Throwable)ex);
            throw ex;
        }
    }

    private boolean tryBreakRecoveryLock(ClusterNodeInfoDocument doc, int recoveredBy) {
        Long recoveryBy = doc.getRecoveryBy();
        if (recoveryBy == null) {
            return false;
        }
        ClusterNodeInfoDocument recovering = this.store.find(Collection.CLUSTER_NODES, String.valueOf(recoveryBy));
        if (recovering == null) {
            return false;
        }
        if (recovering.isActive()) {
            long now = this.clock.getTime();
            long leaseEnd = recovering.getLeaseEndTime();
            if (leaseEnd > now) {
                return false;
            }
        }
        try {
            UpdateOp update = new UpdateOp(Integer.toString(doc.getClusterId()), false);
            update.equals("state", ClusterNodeInfo.ClusterNodeState.ACTIVE.name());
            update.equals("recoveryLock", ClusterNodeInfo.RecoverLockState.ACQUIRED.name());
            update.equals("recoveryBy", recoveryBy);
            update.set("recoveryBy", recoveredBy);
            update.set("leaseEnd", this.clock.getTime() + (long)ClusterNodeInfo.DEFAULT_LEASE_DURATION_MILLIS);
            ClusterNodeInfoDocument old = this.store.findAndUpdate(Collection.CLUSTER_NODES, update);
            if (old != null) {
                LOG.info("Acquired (broke) recovery lock for cluster id {}. Previous lock owner: {}", (Object)doc.getClusterId(), (Object)recoveryBy);
            }
            return old != null;
        }
        catch (RuntimeException ex) {
            LOG.error("Failed to break the recovery lock for clusterNodeId " + doc.getClusterId(), (Throwable)ex);
            throw ex;
        }
    }
}

