/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.util.List;
import java.util.function.Function;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.tree.RootProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeContext;
import org.apache.jackrabbit.oak.plugins.tree.TreeLocation;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeType;
import org.apache.jackrabbit.oak.plugins.tree.TreeTypeProvider;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAuthorizationConfiguration;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositePermissionProviderAnd;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositePermissionProviderOr;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeTreePermission;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.RepositoryPermission;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CompositePermissionProvider
implements AggregatedPermissionProvider {
    private final Root root;
    private final AggregatedPermissionProvider[] pps;
    private final Context ctx;
    private final RootProvider rootProvider;
    private final TreeProvider treeProvider;
    private final RepositoryPermission repositoryPermission;
    private Root immutableRoot;
    private PrivilegeBitsProvider privilegeBitsProvider;
    private final TreeTypeProvider typeProvider;

    CompositePermissionProvider(@NotNull Root root, @NotNull List<AggregatedPermissionProvider> pps, @NotNull Context acContext, @NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider) {
        this.root = root;
        this.pps = pps.toArray(new AggregatedPermissionProvider[0]);
        this.ctx = acContext;
        this.rootProvider = rootProvider;
        this.treeProvider = treeProvider;
        this.repositoryPermission = this.createRepositoryPermission();
        this.immutableRoot = rootProvider.createReadOnlyRoot(root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        this.typeProvider = new TreeTypeProvider((TreeContext)this.ctx);
    }

    static CompositePermissionProvider create(@NotNull Root root, @NotNull List<AggregatedPermissionProvider> pps, @NotNull Context acContext, @NotNull CompositeAuthorizationConfiguration.CompositionType compositionType, @NotNull RootProvider rootProvider, @NotNull TreeProvider treeProvider) {
        if (compositionType == CompositeAuthorizationConfiguration.CompositionType.AND) {
            return new CompositePermissionProviderAnd(root, pps, acContext, rootProvider, treeProvider);
        }
        return new CompositePermissionProviderOr(root, pps, acContext, rootProvider, treeProvider);
    }

    @NotNull
    abstract CompositeAuthorizationConfiguration.CompositionType getCompositeType();

    @NotNull
    abstract RepositoryPermission createRepositoryPermission();

    abstract boolean hasPrivileges(@Nullable Tree var1, @NotNull PrivilegeBitsProvider var2, @NotNull PrivilegeBits var3, @NotNull PrivilegeBits var4);

    @NotNull
    Root getImmutableRoot() {
        return this.immutableRoot;
    }

    @NotNull
    PrivilegeBitsProvider getBitsProvider() {
        return this.privilegeBitsProvider;
    }

    @NotNull
    AggregatedPermissionProvider[] getPermissionProviders() {
        return this.pps;
    }

    public void refresh() {
        this.immutableRoot = this.rootProvider.createReadOnlyRoot(this.root);
        this.privilegeBitsProvider = new PrivilegeBitsProvider(this.immutableRoot);
        for (AggregatedPermissionProvider pp : this.pps) {
            pp.refresh();
        }
    }

    public boolean hasPrivileges(@Nullable Tree tree, String ... privilegeNames) {
        Tree immutableTree = PermissionUtil.getReadOnlyTreeOrNull(tree, this.getImmutableRoot());
        PrivilegeBits privilegeBits = this.privilegeBitsProvider.getBits(privilegeNames);
        if (privilegeBits.isEmpty()) {
            return true;
        }
        PrivilegeBits coveredPrivs = PrivilegeBits.getInstance();
        boolean hasPrivileges = this.hasPrivileges(immutableTree, this.privilegeBitsProvider, privilegeBits, coveredPrivs);
        return hasPrivileges && coveredPrivs.includes(privilegeBits);
    }

    @NotNull
    public RepositoryPermission getRepositoryPermission() {
        return this.repositoryPermission;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreePermission parentPermission) {
        Tree readOnlyTree = PermissionUtil.getReadOnlyTree(tree, this.immutableRoot);
        if (tree.isRoot()) {
            return CompositeTreePermission.create(readOnlyTree, this.treeProvider, this.typeProvider, this.pps, this.getCompositeType());
        }
        if (parentPermission instanceof CompositeTreePermission) {
            return CompositeTreePermission.create(readOnlyTree, this.treeProvider, (CompositeTreePermission)parentPermission);
        }
        return parentPermission.getChildPermission(readOnlyTree.getName(), this.treeProvider.asNodeState(readOnlyTree));
    }

    public boolean isGranted(@NotNull String oakPath, @NotNull String jcrActions) {
        TreeLocation location = TreeLocation.create((Root)this.immutableRoot, (String)oakPath);
        boolean isAcContent = this.ctx.definesLocation(location);
        long permissions = Permissions.getPermissions((String)jcrActions, (TreeLocation)location, (boolean)isAcContent);
        return this.isGranted(location, permissions);
    }

    @NotNull
    public PrivilegeBits supportedPrivileges(@Nullable Tree tree, @Nullable PrivilegeBits privilegeBits) {
        PrivilegeBits result = PrivilegeBits.getInstance();
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            PrivilegeBits supported = aggregatedPermissionProvider.supportedPrivileges(tree, privilegeBits);
            result.add(supported);
        }
        return result;
    }

    public long supportedPermissions(@Nullable Tree tree, @Nullable PropertyState property, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(tree, property, permissions));
    }

    public long supportedPermissions(@NotNull TreeLocation location, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(location, permissions));
    }

    public long supportedPermissions(@NotNull TreePermission treePermission, @Nullable PropertyState property, long permissions) {
        return this.supportedPermissions(aggregatedPermissionProvider -> aggregatedPermissionProvider.supportedPermissions(treePermission, property, permissions));
    }

    private long supportedPermissions(Function<AggregatedPermissionProvider, Long> supported) {
        long coveredPermissions = 0L;
        for (AggregatedPermissionProvider aggregatedPermissionProvider : this.pps) {
            long supportedPermissions = supported.apply(aggregatedPermissionProvider);
            coveredPermissions |= supportedPermissions;
        }
        return coveredPermissions;
    }

    @NotNull
    public TreePermission getTreePermission(@NotNull Tree tree, @NotNull TreeType type, @NotNull TreePermission parentPermission) {
        Tree immutableTree = PermissionUtil.getReadOnlyTree(tree, this.immutableRoot);
        if (tree.isRoot()) {
            return CompositeTreePermission.create(immutableTree, this.treeProvider, this.typeProvider, this.pps, this.getCompositeType());
        }
        if (parentPermission instanceof CompositeTreePermission) {
            return CompositeTreePermission.create(immutableTree, this.treeProvider, (CompositeTreePermission)parentPermission, type);
        }
        return parentPermission.getChildPermission(immutableTree.getName(), this.treeProvider.asNodeState(immutableTree));
    }
}

