/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import com.fasterxml.jackson.databind.JsonNode;
import edu.psu.swe.commons.jaxrs.patch.FailedToAddPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToGetPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToRemovePropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToSetPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToTestPropertyException;
import edu.psu.swe.commons.jaxrs.patch.JsonReference;
import edu.psu.swe.commons.jaxrs.patch.Property;
import edu.psu.swe.commons.jaxrs.patch.PropertyDoesNotExistException;
import edu.psu.swe.commons.jaxrs.patch.PropertyIsNullException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyName
extends JsonReference {
    private static final Logger log;
    private static final Map<Class<?>, Integer> INTEGRAL_TYPES;
    private static final Map<Class<?>, Integer> FLOAT_TYPES;
    private final String name;

    PropertyName(String name, JsonReference next) {
        super(next);
        this.name = name;
    }

    @Override
    public Object add(Object parent, Type parentType, JsonNode jsonValue) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToAddPropertyException {
        Type childType;
        Object origChild;
        Object child;
        Class<?> parentClass = parent.getClass();
        if (!PropertyName.isAnnotated(parentClass)) {
            throw new FailedToAddPropertyException(this.createNotAnnotatedMessage(parentClass));
        }
        if (this.next == null) {
            throw new FailedToAddPropertyException("Cannot add properties to objects: " + this.name);
        }
        try {
            Property property = this.getChild(parent);
            child = property.getObject();
            origChild = this.getChild(parent).getObject();
            if (child == null) {
                throw new PropertyIsNullException("Property is null in " + parentClass.getCanonicalName() + ": " + this.name);
            }
            childType = property.getType();
        }
        catch (IllegalAccessException | IllegalArgumentException unexpected) {
            throw new FailedToAddPropertyException("Unexpected exception occurred when trying to add property in " + parentClass.getCanonicalName() + ": " + this.name, unexpected);
        }
        catch (InvocationTargetException addException) {
            throw new FailedToAddPropertyException("Could not add property because a method threw an exception in " + parentClass.getCanonicalName() + ": " + this.name, addException);
        }
        Object newChild = this.next.add(child, childType, jsonValue);
        if (newChild != origChild) {
            try {
                this.setChild(parent, newChild);
            }
            catch (FailedToSetPropertyException setException) {
                throw new FailedToAddPropertyException("Failed to add property in " + parentClass.getCanonicalName() + ": " + this.name, setException);
            }
        }
        return parent;
    }

    @Override
    public Object remove(Object parent, Type parentType, JsonNode jsonValue) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToRemovePropertyException {
        Type childType;
        Object origChild;
        Object child;
        Class<?> parentClass = parent.getClass();
        if (!PropertyName.isAnnotated(parentClass)) {
            throw new FailedToRemovePropertyException(this.createNotAnnotatedMessage(parentClass));
        }
        if (this.next == null) {
            throw new FailedToRemovePropertyException("Cannot remove properties from objects: " + this.name);
        }
        try {
            Property property = this.getChild(parent);
            child = property.getObject();
            origChild = this.getChild(parent).getObject();
            if (child == null) {
                throw new PropertyIsNullException("Property is null in " + parentClass.getCanonicalName() + ": " + this.name);
            }
            childType = property.getType();
        }
        catch (IllegalAccessException | IllegalArgumentException unexpected) {
            throw new FailedToRemovePropertyException("Unexpected exception occurred when trying to remove property in " + parentClass.getCanonicalName() + ": " + this.name, unexpected);
        }
        catch (InvocationTargetException addException) {
            throw new FailedToRemovePropertyException("Could not remove property because a method threw an exception in " + parentClass.getCanonicalName() + ": " + this.name, addException);
        }
        Object newChild = this.next.remove(child, childType, jsonValue);
        if (newChild != origChild) {
            try {
                this.setChild(parent, newChild);
            }
            catch (FailedToSetPropertyException setException) {
                throw new FailedToRemovePropertyException("Failed to remove property in " + parentClass.getCanonicalName() + ": " + this.name, setException);
            }
        }
        return parent;
    }

    @Override
    public Object get(Object parent, Type parentType) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToGetPropertyException {
        Object child;
        Class<?> parentClass = parent.getClass();
        if (!PropertyName.isAnnotated(parentClass)) {
            throw new FailedToGetPropertyException(this.createNotAnnotatedMessage(parentClass));
        }
        try {
            Property childProperty = this.getChild(parent);
            if (this.next != null) {
                Object propertyValue = childProperty.getObject();
                Type propertyType = childProperty.getType();
                if (propertyValue == null) {
                    throw new PropertyIsNullException("Property of " + parentClass.getCanonicalName() + " is null: " + this.name);
                }
                child = this.next.get(propertyValue, propertyType);
            } else {
                child = childProperty.getObject();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException unexpected) {
            throw new FailedToGetPropertyException("Unexpected exception: " + this.name, unexpected);
        }
        catch (InvocationTargetException getException) {
            throw new FailedToGetPropertyException("Getter method threw an exception when accessing property of " + parentClass.getCanonicalName() + ": " + this.name, getException);
        }
        return child;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void set(Object parent, Type parentType, JsonNode jsonValue) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToSetPropertyException {
        block37: {
            Class<?> parentClass = parent.getClass();
            if (!PropertyName.isAnnotated(parentClass)) {
                throw new FailedToSetPropertyException(this.createNotAnnotatedMessage(parentClass));
            }
            if (this.next != null) {
                try {
                    Property property = this.getChild(parent);
                    Object child = property.getObject();
                    Type childType = property.getType();
                    if (child == null) {
                        throw new PropertyIsNullException("Property in " + parentClass.getCanonicalName() + " is null: " + this.name);
                    }
                    this.next.set(child, childType, jsonValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException getException) {
                    throw new FailedToSetPropertyException("Failed to set property because it could not be reached: " + this.name, getException);
                }
            }
            try {
                for (Class<?> clazz = parentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    String name;
                    XmlElement xmlElement;
                    if (clazz.getAnnotation(XmlType.class) == null && clazz.getAnnotation(XmlRootElement.class) == null) continue;
                    for (Field field : clazz.getDeclaredFields()) {
                        Object value;
                        if (Modifier.isStatic(field.getModifiers()) || (xmlElement = field.getAnnotation(XmlElement.class)) == null) continue;
                        String xmlElementName = xmlElement.name();
                        String fieldName = field.getName();
                        String string = name = "##default".equals(xmlElementName) ? fieldName : xmlElementName;
                        if (!this.name.equals(name)) continue;
                        String setterName = PropertyName.setter(fieldName);
                        Stream<Method> candidates = Stream.of(clazz.getDeclaredMethods()).filter(method -> !Modifier.isStatic(method.getModifiers()) && method.getParameterCount() == 1 && setterName.equals(method.getName()));
                        if (jsonValue.isBoolean()) {
                            candidates = candidates.filter(method -> {
                                Class<?> parameter = method.getParameterTypes()[0];
                                return parameter == Boolean.class || parameter == Boolean.TYPE;
                            });
                        } else if (jsonValue.isTextual()) {
                            candidates = candidates.filter(method -> method.getParameterTypes()[0] == String.class);
                        } else if (jsonValue.isFloatingPointNumber()) {
                            candidates = candidates.filter(method -> FLOAT_TYPES.containsKey(method.getParameterTypes()[0])).sorted((a, b) -> FLOAT_TYPES.get(a.getParameterTypes()[0]) - FLOAT_TYPES.get(b.getParameterTypes()[0]));
                        } else if (jsonValue.isIntegralNumber()) {
                            candidates = candidates.filter(method -> INTEGRAL_TYPES.containsKey(method.getParameterTypes()[0])).sorted((a, b) -> INTEGRAL_TYPES.get(a.getParameterTypes()[0]) - INTEGRAL_TYPES.get(b.getParameterTypes()[0]));
                        } else if (jsonValue.isArray()) {
                            candidates = candidates.filter(method -> {
                                Class<?> parameterType = method.getParameterTypes()[0];
                                return parameterType.isArray() || Collection.class.isAssignableFrom(parameterType);
                            });
                        } else if (jsonValue.isObject()) {
                            candidates = candidates.filter(method -> {
                                Class<?> parameterType = method.getParameterTypes()[0];
                                return !parameterType.isPrimitive() && !parameterType.isArray() && !Collection.class.isAssignableFrom(parameterType);
                            });
                        } else if (jsonValue.isNull()) {
                            candidates = candidates.filter(method -> !method.getParameterTypes()[0].isPrimitive());
                        } else {
                            throw new IllegalArgumentException("Unexpected jackson class: " + jsonValue.getClass().getCanonicalName());
                        }
                        List setters = candidates.collect(Collectors.toList());
                        for (Method setter : setters) {
                            Type parameterType = setter.getParameters()[0].getParameterizedType();
                            setter.setAccessible(true);
                            try {
                                Object value2 = super.convert(jsonValue, parameterType);
                            }
                            catch (IllegalArgumentException ignored) {
                                log.debug("Failed to convert: {}", (Throwable)ignored);
                                continue;
                            }
                            try {
                                void value2;
                                setter.invoke(parent, value2);
                                break block37;
                            }
                            catch (IllegalAccessException | IllegalArgumentException ignored) {
                                log.debug("Setter method failed: {}", (Throwable)ignored);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                throw new FailedToSetPropertyException("Setter method of " + parentClass.getCanonicalName() + " threw an exception: " + this.name, invocationTargetException);
                            }
                        }
                        this.checkFinal(field);
                        Type fieldType = field.getGenericType();
                        try {
                            value = super.convert(jsonValue, fieldType);
                        }
                        catch (IllegalArgumentException convertException) {
                            throw new FailedToSetPropertyException("Failed to convert JSON to " + fieldType.getTypeName() + ": " + this.name, convertException);
                        }
                        field.setAccessible(true);
                        try {
                            field.set(parent, value);
                            break block37;
                        }
                        catch (IllegalAccessException | IllegalArgumentException setException) {
                            throw new FailedToSetPropertyException("Failed to directly set property of " + parentClass.getCanonicalName() + ": " + this.name, setException);
                        }
                    }
                    for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                        Object value;
                        xmlElement = ((Method)accessibleObject).getAnnotation(XmlElement.class);
                        String methodName = ((Method)accessibleObject).getName();
                        if (xmlElement == null || ((Method)accessibleObject).getParameterCount() != 1 || !methodName.startsWith("set")) continue;
                        String xmlElementName = xmlElement.name();
                        String string = name = "##default".equals(xmlElementName) ? PropertyName.propertyName((Method)accessibleObject) : xmlElementName;
                        if (!this.name.equals(name)) continue;
                        Type methodType = ((Executable)accessibleObject).getParameters()[0].getParameterizedType();
                        try {
                            value = super.convert(jsonValue, methodType);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw new FailedToSetPropertyException("Failed to convert JSON to " + methodType.getTypeName() + " in " + parentClass.getCanonicalName() + ": " + this.name);
                        }
                        ((Method)accessibleObject).setAccessible(true);
                        ((Method)accessibleObject).invoke(parent, value);
                        break block37;
                    }
                }
                throw new PropertyDoesNotExistException("Property does not exist in " + parentClass.getCanonicalName() + ": " + this.name);
            }
            catch (IllegalAccessException | IllegalArgumentException unexpected) {
                throw new FailedToSetPropertyException("An unexpected exception occurred when accessing " + parentClass.getCanonicalName() + ": " + this.name, unexpected);
            }
            catch (InvocationTargetException setException) {
                throw new FailedToSetPropertyException("An exception was thrown when attempting to access " + parentClass.getCanonicalName() + ": " + this.name);
            }
        }
    }

    @Override
    public boolean test(Object parent, Type parentType, JsonNode jsonValue) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToTestPropertyException {
        boolean result;
        block11: {
            Class<?> parentClass = parent.getClass();
            if (!PropertyName.isAnnotated(parentClass)) {
                throw new FailedToTestPropertyException(this.createNotAnnotatedMessage(parentClass));
            }
            try {
                Object value;
                Type valueType;
                Object child;
                block12: {
                    if (this.next != null) {
                        Property property = this.getChild(parent);
                        Object child2 = property.getObject();
                        if (child2 == null) {
                            throw new PropertyIsNullException("Property in " + parentClass.getCanonicalName() + " is null: " + this.name);
                        }
                        Type childType = property.getType();
                        result = this.next.test(child2, childType, jsonValue);
                        break block11;
                    }
                    for (Class<?> clazz = parentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                        for (Field field : clazz.getDeclaredFields()) {
                            String name;
                            XmlElement xmlElement;
                            if (Modifier.isStatic(field.getModifiers()) || (xmlElement = field.getAnnotation(XmlElement.class)) == null) continue;
                            String xmlElementName = xmlElement.name();
                            String fieldName = field.getName();
                            String string = name = "##default".equals(xmlElementName) ? fieldName : xmlElementName;
                            if (!this.name.equals(name)) continue;
                            String getterName = PropertyName.getter(fieldName);
                            for (Method method : clazz.getDeclaredMethods()) {
                                if (PropertyName.isNotGetterMethod(method, getterName)) continue;
                                method.setAccessible(true);
                                child = method.invoke(parent, new Object[0]);
                                valueType = method.getGenericReturnType();
                                break block12;
                            }
                            field.setAccessible(true);
                            child = field.get(parent);
                            valueType = field.getGenericType();
                            break block12;
                        }
                    }
                    throw new PropertyDoesNotExistException("Property does not exist in " + parentClass.getCanonicalName() + ": " + this.name);
                }
                try {
                    value = super.convert(jsonValue, valueType);
                }
                catch (IllegalArgumentException convertException) {
                    throw new FailedToTestPropertyException("Failed to convert JSON to " + valueType.getTypeName() + ": " + this.name, convertException);
                }
                result = Objects.equals(child, value);
            }
            catch (IllegalAccessException | IllegalArgumentException unexpected) {
                throw new FailedToTestPropertyException("An unexpected exception occurred when accessing " + parentClass.getCanonicalName() + ": " + this.name, unexpected);
            }
            catch (InvocationTargetException setException) {
                throw new FailedToTestPropertyException("An exception was thrown by a method when attempting to access " + parentClass.getCanonicalName() + ": " + this.name, setException);
            }
        }
        return result;
    }

    private Property getChild(Object object) throws PropertyDoesNotExistException, PropertyIsNullException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Property child;
        block4: {
            Class<?> parentClass;
            for (Class<?> clazz = parentClass = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                String xmlElementName;
                XmlElement xmlElement;
                for (Field field : clazz.getDeclaredFields()) {
                    String name;
                    if (Modifier.isStatic(field.getModifiers()) || (xmlElement = field.getAnnotation(XmlElement.class)) == null) continue;
                    xmlElementName = xmlElement.name();
                    String fieldName = field.getName();
                    String string = name = "##default".equals(xmlElementName) ? fieldName : xmlElementName;
                    if (!this.name.equals(name)) continue;
                    String getterName = PropertyName.getter(fieldName);
                    for (Method method : clazz.getDeclaredMethods()) {
                        if (PropertyName.isNotGetterMethod(method, getterName)) continue;
                        method.setAccessible(true);
                        Object childObject = method.invoke(object, new Object[0]);
                        Type childType = method.getGenericReturnType();
                        child = new Property(childObject, childType);
                        break block4;
                    }
                    field.setAccessible(true);
                    Object childObject = field.get(object);
                    Type childType = field.getGenericType();
                    child = new Property(childObject, childType);
                    break block4;
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    String name;
                    if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || (xmlElement = ((Method)accessibleObject).getAnnotation(XmlElement.class)) == null || ((Method)accessibleObject).getParameterCount() != 0 || !((Method)accessibleObject).getName().startsWith("get")) continue;
                    xmlElementName = xmlElement.name();
                    String string = name = "##default".equals(xmlElementName) ? PropertyName.propertyName((Method)accessibleObject) : xmlElementName;
                    if (!this.name.equals(name)) continue;
                    Object childObject = ((Method)accessibleObject).invoke(object, new Object[0]);
                    Type childType = ((Method)accessibleObject).getGenericReturnType();
                    child = new Property(childObject, childType);
                    break block4;
                }
            }
            throw new PropertyDoesNotExistException("Property does not exist in " + parentClass.getCanonicalName() + ": " + this.name);
        }
        return child;
    }

    private void setChild(Object parent, Object child) throws FailedToSetPropertyException {
        block6: {
            Class<?> parentClass = parent.getClass();
            try {
                for (Class<?> clazz = parentClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    String xmlElementName;
                    XmlElement xmlElement;
                    for (Field field : clazz.getDeclaredFields()) {
                        String name;
                        if (Modifier.isStatic(field.getModifiers()) || (xmlElement = field.getAnnotation(XmlElement.class)) == null) continue;
                        xmlElementName = xmlElement.name();
                        String fieldName = field.getName();
                        String string = name = "##default".equals(xmlElementName) ? fieldName : xmlElementName;
                        if (!this.name.equals(name)) continue;
                        String setterName = PropertyName.setter(fieldName);
                        for (Method method : clazz.getDeclaredMethods()) {
                            if (PropertyName.isNotSetterMethod(method, setterName)) continue;
                            method.setAccessible(true);
                            method.invoke(parent, child);
                            break block6;
                        }
                        this.checkFinal(field);
                        field.setAccessible(true);
                        field.set(parent, child);
                        break block6;
                    }
                    for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                        String name;
                        if (Modifier.isStatic(((Method)accessibleObject).getModifiers()) || (xmlElement = ((Method)accessibleObject).getAnnotation(XmlElement.class)) == null || ((Method)accessibleObject).getParameterCount() != 1 || !((Method)accessibleObject).getName().startsWith("set")) continue;
                        xmlElementName = xmlElement.name();
                        String string = name = "##default".equals(xmlElementName) ? PropertyName.propertyName((Method)accessibleObject) : xmlElementName;
                        if (!this.name.equals(name)) continue;
                        ((Method)accessibleObject).setAccessible(true);
                        ((Method)accessibleObject).invoke(parent, child);
                        break block6;
                    }
                }
                throw new RuntimeException("Property should have been found: " + this.name);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException unexpected) {
                throw new RuntimeException("Unexpected exception", unexpected);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    private void checkFinal(Field field) throws FailedToSetPropertyException {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new FailedToSetPropertyException("Property is final in " + field.getDeclaringClass().getCanonicalName() + ": " + this.name);
        }
    }

    private static String getter(String name) {
        String getter = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return getter;
    }

    private static String propertyName(Method method) {
        String methodName = method.getName();
        String name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        return name;
    }

    private static String setter(String name) {
        String setter = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        return setter;
    }

    private static boolean isAnnotated(Class<?> clazz) {
        boolean isAnnotated = false;
        while (clazz != Object.class) {
            boolean bl = isAnnotated = clazz.getAnnotation(XmlType.class) != null || clazz.getAnnotation(XmlRootElement.class) != null;
            if (isAnnotated) break;
            clazz = clazz.getSuperclass();
        }
        return isAnnotated;
    }

    private String createNotAnnotatedMessage(Class<?> clazz) {
        String message = "Cannot set property of " + clazz.getCanonicalName() + ", : " + this.name;
        return message;
    }

    private static boolean isNotGetterMethod(Method method, String getterName) {
        boolean undesired = method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || !getterName.equals(method.getName());
        return undesired;
    }

    private static boolean isNotSetterMethod(Method method, String setterName) {
        boolean undesired = method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || !setterName.equals(method.getName());
        return undesired;
    }

    static {
        int i;
        log = LoggerFactory.getLogger(PropertyName.class);
        Class[] integralTypes = new Class[]{Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE};
        Class[] floatTypes = new Class[]{Double.class, Double.TYPE, Float.class, Float.TYPE};
        INTEGRAL_TYPES = new HashMap(integralTypes.length);
        FLOAT_TYPES = new HashMap(floatTypes.length);
        for (i = 0; i < integralTypes.length; i += 2) {
            INTEGRAL_TYPES.put(integralTypes[i], i);
            INTEGRAL_TYPES.put(integralTypes[i + 1], i);
        }
        for (i = 0; i < floatTypes.length; i += 2) {
            FLOAT_TYPES.put(floatTypes[i], i);
            FLOAT_TYPES.put(floatTypes[i + 1], i);
        }
    }
}

