/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.suggestionbox.notification;

import org.owasp.encoder.Encode;
import org.silverpeas.components.suggestionbox.model.Suggestion;
import org.silverpeas.components.suggestionbox.notification.AbstractSuggestionBoxUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.template.SilverpeasTemplate;

public abstract class AbstractSuggestionUserNotification
extends AbstractSuggestionBoxUserNotification<Suggestion> {
    private final NotifAction action;

    protected AbstractSuggestionUserNotification(Suggestion resource, NotifAction action) {
        super(resource);
        this.action = action;
    }

    protected void performTemplateData(String language, Suggestion resource, SilverpeasTemplate template) {
        this.getNotificationMetaData().addLanguage(language, this.getTitle(language), "");
        template.setAttribute("title", (Object)Encode.forHtml((String)resource.getTitle()));
        template.setAttribute("content", (Object)Encode.forHtml((String)resource.getContent()));
        template.setAttribute("authorName", (Object)resource.getCreator().getDisplayedName());
        template.setAttribute("senderName", (Object)this.getSenderName());
    }

    protected void performNotificationResource(String language, Suggestion resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
    }

    protected boolean stopWhenNoUserToNotify() {
        return !NotifAction.REPORT.equals((Object)this.action);
    }

    protected NotifAction getAction() {
        return this.action;
    }

    protected String getComponentInstanceId() {
        return ((Suggestion)((Object)this.getResource())).getSuggestionBox().getComponentInstanceId();
    }

    @Override
    protected User getSenderDetail() {
        if (NotifAction.REPORT.equals((Object)this.action)) {
            return null;
        }
        return ((Suggestion)((Object)this.getResource())).getCreator();
    }

    protected final String getSender() {
        User sender = this.getSenderDetail();
        if (sender != null) {
            return sender.getId();
        }
        return ((Suggestion)((Object)this.getResource())).getCreatorId();
    }
}

