/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.transaction.Transactional;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.model.ResourceValidator;
import org.silverpeas.components.resourcesmanager.service.ResourceService;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.kernel.annotation.Defined;
import org.silverpeas.kernel.annotation.NonNull;
import org.silverpeas.kernel.annotation.Technical;
import org.silverpeas.kernel.util.StringUtil;

@Technical
@Service
@Singleton
public class ResourcesManagersSynchronizer {
    @Inject
    private ResourceService resourceService;

    @Transactional
    public void synchronize(@Defined String instanceId, @NonNull Set<String> removedUsersId) {
        StringUtil.requireDefined((String)instanceId);
        Objects.requireNonNull(removedUsersId);
        List<Resource> resources = this.resourceService.getResources(instanceId);
        this.updateValidators(resources, removedUsersId);
    }

    private void updateValidators(List<Resource> resources, Set<String> removedUsersId) {
        resources.forEach(r -> {
            List<ResourceValidator> managerIds = r.getManagers().stream().map(ResourceValidator::getManagerId).filter(m -> !removedUsersId.contains(String.valueOf(m))).map(m -> new ResourceValidator(r.getIdAsLong(), (long)m)).collect(Collectors.toList());
            r.setManagers(managerIds);
            this.resourceService.updateResource((Resource)((Object)r));
        });
    }
}

