/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply.service;

import java.text.ParseException;
import java.util.Date;
import org.silverpeas.components.questionreply.model.Question;
import org.silverpeas.core.Identifiable;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.i18n.AbstractBean;
import org.silverpeas.core.persistence.jdbc.bean.IdPK;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.util.StringUtil;

public final class QuestionHeader
extends AbstractBean
implements LocalizedContribution,
Identifiable {
    private static final long serialVersionUID = 311303663095375317L;
    private long id;
    private String instanceId;
    private String title;
    private String date;
    private String creatorId;

    public void init(Question question) {
        this.id = ((IdPK)question.getPK()).getIdAsLong();
        this.setName(question.getTitle());
        this.setDescription(question.getContent());
        this.title = question.getTitle();
        this.date = question.getCreationDate();
    }

    public QuestionHeader(Question question) {
        this.init(question);
    }

    public QuestionHeader(Question question, String instanceId, String date, String creatorId) {
        this.init(question);
        this.instanceId = instanceId;
        this.date = date;
        this.creatorId = creatorId;
    }

    public String getId() {
        return Long.toString(this.id);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getInstanceId(), (String)this.getId(), (String)this.getContributionType());
    }

    public String getTitle() {
        return this.title;
    }

    public String getContributionType() {
        return "Question";
    }

    public Date getCreationDate() {
        if (StringUtil.isDefined((String)this.date)) {
            try {
                return DateUtil.parseDate((String)this.date);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public Date getLastUpdateDate() {
        return this.getCreationDate();
    }

    public User getCreator() {
        return User.getById((String)this.getCreatorId());
    }

    public User getLastUpdater() {
        return this.getCreator();
    }

    public String getCreatorId() {
        return this.creatorId;
    }
}

