/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.net.URI;
import java.security.InvalidParameterException;
import java.util.Iterator;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.text.TextHyperlink;
import org.odftoolkit.simple.text.TextHyperlinkContainer;
import org.w3c.dom.Node;

class AbstractTextHyperlinkContainer
implements TextHyperlinkContainer {
    OdfElement linkContainer;

    public AbstractTextHyperlinkContainer(OdfElement parent) {
        if (!(parent instanceof TextPElement || parent instanceof TextHElement || parent instanceof TextSpanElement)) {
            throw new InvalidParameterException(parent.getClass() + "is not a valid element.");
        }
        this.linkContainer = parent;
    }

    @Override
    public TextHyperlink applyHyperlink(URI linkto) {
        OdfElement parent = this.linkContainer;
        this.removeHyperlinks();
        TextAElement aElement = (TextAElement)((OdfContentDom)parent.getOwnerDocument()).newOdfElement(TextAElement.class);
        aElement.setXlinkTypeAttribute("simple");
        aElement.setXlinkHrefAttribute(linkto.toString());
        for (Node node = parent.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node thisNode = node;
            parent.removeChild(thisNode);
            aElement.appendChild(thisNode);
        }
        parent.appendChild((Node)aElement);
        return TextHyperlink.getInstanceof(aElement);
    }

    @Override
    public void removeHyperlinks() {
        OdfElement parent = this.linkContainer;
        TextAElement aElement = (TextAElement)OdfElement.findFirstChildNode(TextAElement.class, (Node)parent);
        while (aElement != null) {
            for (Node node = aElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                Node thisNode = node;
                aElement.removeChild(thisNode);
                parent.insertBefore(thisNode, (Node)aElement);
            }
            TextAElement thisElement = aElement;
            aElement = (TextAElement)OdfElement.findNextChildNode(TextAElement.class, (Node)aElement);
            parent.removeChild((Node)thisElement);
        }
    }

    public SimpleHyperlinkIterator getHyperlinkIterator() {
        return new SimpleHyperlinkIterator(this.linkContainer);
    }

    @Override
    public TextHyperlink appendHyperlink(String text, URI linkto) {
        OdfElement parent = this.linkContainer;
        TextAElement aElement = (TextAElement)((OdfContentDom)parent.getOwnerDocument()).newOdfElement(TextAElement.class);
        aElement.setXlinkTypeAttribute("simple");
        aElement.setXlinkHrefAttribute(linkto.toString());
        aElement.setTextContent(text);
        parent.appendChild((Node)aElement);
        return TextHyperlink.getInstanceof(aElement);
    }

    private class SimpleHyperlinkIterator
    implements Iterator<TextHyperlink> {
        private OdfElement containerElement;
        private TextHyperlink nextElement = null;
        private TextHyperlink tempElement = null;

        private SimpleHyperlinkIterator(OdfElement container) {
            this.containerElement = container;
        }

        @Override
        public boolean hasNext() {
            this.tempElement = this.findNext(this.nextElement);
            return this.tempElement != null;
        }

        @Override
        public TextHyperlink next() {
            if (this.tempElement != null) {
                this.nextElement = this.tempElement;
                this.tempElement = null;
            } else {
                this.nextElement = this.findNext(this.nextElement);
            }
            if (this.nextElement == null) {
                return null;
            }
            return this.nextElement;
        }

        @Override
        public void remove() {
            if (this.nextElement == null) {
                throw new IllegalStateException("please call next() first.");
            }
            this.containerElement.removeChild((Node)this.nextElement.getOdfElement());
        }

        private TextHyperlink findNext(TextHyperlink thisLink) {
            TextAElement nextLink = null;
            nextLink = thisLink == null ? (TextAElement)OdfElement.findFirstChildNode(TextAElement.class, (Node)this.containerElement) : (TextAElement)OdfElement.findNextChildNode(TextAElement.class, (Node)thisLink.getOdfElement());
            if (nextLink != null) {
                return TextHyperlink.getInstanceof(nextLink);
            }
            return null;
        }
    }
}

