/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.util.Objects;
import java.util.Optional;
import org.silverpeas.components.gallery.constant.MediaResolution;
import org.silverpeas.components.gallery.constant.MediaType;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.core.io.file.SilverpeasFile;
import org.silverpeas.core.media.streaming.StreamingProvider;
import org.silverpeas.kernel.util.StringUtil;

public class Streaming
extends Media {
    private static final long serialVersionUID = 5772513957256327862L;
    private String homepageUrl = "";
    private StreamingProvider provider;

    @Override
    public MediaType getType() {
        return MediaType.Streaming;
    }

    public Streaming() {
    }

    protected Streaming(Streaming other) {
        super(other);
        this.homepageUrl = other.homepageUrl;
        this.provider = other.provider;
    }

    public String getHomepageUrl() {
        return this.homepageUrl;
    }

    public void setHomepageUrl(String url) {
        this.homepageUrl = url;
    }

    public Optional<StreamingProvider> getProvider() {
        return Optional.ofNullable(this.provider);
    }

    public void setProvider(StreamingProvider provider) {
        this.provider = provider;
    }

    public static String getResourceType() {
        return MediaType.Streaming.name();
    }

    @Override
    public String getApplicationOriginalUrl() {
        if (StringUtil.isNotDefined((String)this.getId())) {
            return super.getApplicationOriginalUrl();
        }
        return this.getApplicationThumbnailUrl(MediaResolution.PREVIEW);
    }

    @Override
    public SilverpeasFile getFile(MediaResolution mediaResolution, String size) {
        return SilverpeasFile.NO_FILE;
    }

    @Override
    public String getApplicationEmbedUrl(MediaResolution mediaResolution) {
        return "";
    }

    @Override
    public Streaming getCopy() {
        return new Streaming(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Streaming streaming = (Streaming)o;
        return Objects.equals(this.homepageUrl, streaming.homepageUrl) && Objects.equals(this.provider, streaming.provider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.homepageUrl, this.provider);
    }
}

