/*
 * Copyright (C) 2000 - 2024 Silverpeas
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * As a special exception to the terms and conditions of version 3.0 of
 * the GPL, you may redistribute this Program in connection with Free/Libre
 * Open Source Software ("FLOSS") applications as described in Silverpeas's
 * FLOSS exception. You should have received a copy of the text describing
 * the FLOSS exception, and it is also available here:
 * "http://www.silverpeas.org/docs/core/legal/floss_exception.html"
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package org.silverpeas.components.classifieds.servlets.handler;

import org.silverpeas.components.classifieds.control.ClassifiedsSessionController;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.servlets.FunctionHandler;
import org.silverpeas.core.web.http.HttpRequest;

import java.util.Collection;

/**
 * Use Case : for moderator, show all classifieds waiting for validation
 *
 * @author Ludovic Bertin
 *
 */
public class ListToValidateHandler extends FunctionHandler {

  @Override
  public String getDestination(ClassifiedsSessionController classifiedsSC,
      HttpRequest request) throws Exception{

    // Retrieve classifieds waiting for validation
    Collection<ClassifiedDetail> classifieds = classifiedsSC.getClassifiedsToValidate();

    // Stores objects in request
    request.setAttribute("InstanceSettings", classifiedsSC.getInstanceSettings());
    request.setAttribute("Classifieds", classifieds);
    request.setAttribute("TitlePath", "classifieds.viewClassifiedToValidate");

    // Returns jsp to redirect to
    return "classifieds.jsp";
   }

}
