/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

class JsopNodeStateDiffer
implements NodeStateDiffer {
    private final String jsonDiff;
    private boolean withoutPropertyChanges = false;

    JsopNodeStateDiffer(String diff) {
        this.jsonDiff = diff == null ? "" : diff;
    }

    JsopNodeStateDiffer withoutPropertyChanges() {
        this.withoutPropertyChanges = true;
        return this;
    }

    @Override
    public boolean compare(final @NotNull AbstractDocumentNodeState node, final @NotNull AbstractDocumentNodeState base, final @NotNull NodeStateDiff diff) {
        if (!this.withoutPropertyChanges && !AbstractNodeState.comparePropertiesAgainstBaseState((NodeState)node, (NodeState)base, (NodeStateDiff)diff)) {
            return false;
        }
        return DiffCache.parseJsopDiff(this.jsonDiff, new DiffCache.Diff(){

            @Override
            public boolean childNodeAdded(String name) {
                return diff.childNodeAdded(name, node.getChildNode(name));
            }

            @Override
            public boolean childNodeChanged(String name) {
                boolean continueComparison = true;
                NodeState baseChild = base.getChildNode(name);
                NodeState nodeChild = node.getChildNode(name);
                if (baseChild.exists()) {
                    continueComparison = nodeChild.exists() ? JsopNodeStateDiffer.compareExisting(baseChild, nodeChild, name, diff) : diff.childNodeDeleted(name, baseChild);
                } else if (nodeChild.exists()) {
                    continueComparison = diff.childNodeAdded(name, nodeChild);
                }
                return continueComparison;
            }

            @Override
            public boolean childNodeDeleted(String name) {
                return diff.childNodeDeleted(name, base.getChildNode(name));
            }
        });
    }

    private static boolean compareExisting(NodeState baseChild, NodeState nodeChild, String name, NodeStateDiff diff) {
        if (baseChild instanceof AbstractDocumentNodeState && nodeChild instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState beforeChild = (AbstractDocumentNodeState)baseChild;
            AbstractDocumentNodeState afterChild = (AbstractDocumentNodeState)nodeChild;
            if (beforeChild.getLastRevision().equals(afterChild.getLastRevision())) {
                return true;
            }
        }
        return diff.childNodeChanged(name, baseChild, nodeChild);
    }
}

