/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.plugins.document.ModifiedDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.util.ReverseNodeStateDiff;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public abstract class AbstractDocumentNodeState
extends AbstractNodeState {
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger((String)(AbstractDocumentNodeState.class.getName() + ".perf")));

    public abstract Path getPath();

    public abstract RevisionVector getLastRevision();

    public abstract RevisionVector getRootRevision();

    public abstract boolean isFromExternalChange();

    public abstract AbstractDocumentNodeState withRootRevision(@NotNull RevisionVector var1, boolean var2);

    public abstract boolean hasNoChildren();

    protected abstract NodeStateDiffer getNodeStateDiffer();

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState other = (AbstractDocumentNodeState)((Object)that);
            if (!this.getPath().equals(other.getPath())) {
                return false;
            }
            if (this.revisionEquals(other)) {
                return true;
            }
        } else if (that instanceof ModifiedNodeState) {
            ModifiedNodeState modified = (ModifiedNodeState)that;
            NodeState baseState = modified.getBaseState();
            if (baseState instanceof ModifiedDocumentNodeState) {
                baseState = ((ModifiedDocumentNodeState)baseState).getBaseState();
            }
            if (baseState == this) {
                return EqualsDiff.equals((NodeState)this, (NodeState)modified);
            }
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals((NodeState)this, (NodeState)((NodeState)that));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        ModifiedNodeState mBase;
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState((NodeState)this, (NodeStateDiff)diff);
        }
        if (base instanceof AbstractDocumentNodeState) {
            AbstractDocumentNodeState mBase2 = (AbstractDocumentNodeState)base;
            if (this.getPath().equals(mBase2.getPath())) {
                boolean bl;
                block10: {
                    if (this.revisionEquals(mBase2)) {
                        return true;
                    }
                    long start = perfLogger.start();
                    try {
                        bl = this.getNodeStateDiffer().compare(this, mBase2, diff);
                        if (start <= 0L) break block10;
                    }
                    catch (Throwable throwable) {
                        if (start > 0L) {
                            perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, lastRevision={}, base.path={}, base.lastRevision={}", new Object[]{this.getPath(), this.getLastRevision(), mBase2.getPath(), mBase2.getLastRevision()});
                        }
                        throw throwable;
                    }
                    perfLogger.end(start, 1L, "compareAgainstBaseState, path={}, lastRevision={}, base.path={}, base.lastRevision={}", new Object[]{this.getPath(), this.getLastRevision(), mBase2.getPath(), mBase2.getLastRevision()});
                }
                return bl;
            }
        } else if (base instanceof ModifiedNodeState && (mBase = (ModifiedNodeState)base).getBaseState() == this) {
            return mBase.compareAgainstBaseState((NodeState)this, (NodeStateDiff)new ReverseNodeStateDiff(diff));
        }
        return super.compareAgainstBaseState(base, diff);
    }

    private boolean revisionEquals(AbstractDocumentNodeState other) {
        if (this.getRootRevision().asTrunkRevision().equals(other.getRootRevision().asTrunkRevision())) {
            return true;
        }
        return this.getLastRevision() != null && this.getLastRevision().equals(other.getLastRevision());
    }
}

