/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.principal;

import java.security.Principal;
import java.util.Iterator;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EveryoneFilter {
    private EveryoneFilter() {
    }

    public static Iterator<Principal> filter(@NotNull Iterator<Principal> resultPrincipals, @Nullable String nameHint, int searchType, long offset, long limit) {
        boolean noRange;
        boolean bl = noRange = offset == 0L && limit == Long.MAX_VALUE;
        if (noRange && EveryoneFilter.matchesEveryone(nameHint, searchType)) {
            Iterator principals = Iterators.concat(resultPrincipals, (Iterator)Iterators.singletonIterator((Object)EveryonePrincipal.getInstance()));
            return Iterators.filter((Iterator)principals, (Predicate)new EveryonePredicate());
        }
        return resultPrincipals;
    }

    private static boolean matchesEveryone(@Nullable String nameHint, int searchType) {
        return searchType != 1 && (nameHint == null || "everyone".contains(nameHint));
    }

    private static final class EveryonePredicate
    implements Predicate<Principal> {
        private boolean servedEveryone = false;

        private EveryonePredicate() {
        }

        public boolean apply(@Nullable Principal principal) {
            if (principal != null && "everyone".equals(principal.getName())) {
                if (this.servedEveryone) {
                    return false;
                }
                this.servedEveryone = true;
                return true;
            }
            return true;
        }
    }
}

