/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.patch;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import edu.psu.swe.commons.jaxrs.patch.FailedToAddPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToGetPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToRemovePropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToSetPropertyException;
import edu.psu.swe.commons.jaxrs.patch.FailedToTestPropertyException;
import edu.psu.swe.commons.jaxrs.patch.PropertyDoesNotExistException;
import edu.psu.swe.commons.jaxrs.patch.PropertyIsNullException;
import edu.psu.swe.commons.jaxrs.server.ObjectMapperContextResolver;
import java.lang.reflect.Type;

abstract class JsonReference {
    protected final JsonReference next;
    protected final ObjectMapper objectMapper;

    protected JsonReference(JsonReference next) {
        this.next = next;
        this.objectMapper = next == null ? new ObjectMapperContextResolver().getContext(null) : null;
    }

    abstract Object add(Object var1, Type var2, JsonNode var3) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToAddPropertyException;

    abstract Object remove(Object var1, Type var2, JsonNode var3) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToRemovePropertyException;

    abstract Object get(Object var1, Type var2) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToGetPropertyException;

    abstract void set(Object var1, Type var2, JsonNode var3) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToSetPropertyException;

    abstract boolean test(Object var1, Type var2, JsonNode var3) throws PropertyDoesNotExistException, PropertyIsNullException, FailedToTestPropertyException;

    protected Object convert(JsonNode jsonValue, Type type) throws IllegalArgumentException {
        if (jsonValue.isNull()) {
            if (type instanceof Class && ((Class)type).isPrimitive()) {
                throw new IllegalArgumentException("Cannot set " + type.getTypeName() + " to null");
            }
        } else {
            if (!jsonValue.isTextual() && type == String.class) {
                throw new IllegalArgumentException("Cannot convert to " + type.getTypeName() + " from non-string");
            }
            if (!(jsonValue.isFloatingPointNumber() || type != Float.class && type != Float.TYPE && type != Double.class && type != Double.TYPE)) {
                throw new IllegalArgumentException("Cannot convert to " + type.getTypeName() + " from non-floating point");
            }
            if (!(jsonValue.isIntegralNumber() || type != Long.class && type != Long.TYPE && type != Integer.class && type != Integer.TYPE && type != Short.class && type != Short.TYPE && type != Byte.class && type != Byte.TYPE && type != Character.class && type != Character.TYPE)) {
                throw new IllegalArgumentException("Cannot convert to " + type.getTypeName() + " from non-integral");
            }
        }
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        Object value = this.objectMapper.convertValue((Object)jsonValue, javaType);
        return value;
    }
}

