/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.questionreply;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.core.admin.component.ComponentInstancePreDestruction;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
@Named
public class QuestionReplyInstancePreDestruction
implements ComponentInstancePreDestruction {
    private static final String RECIPIENT_DELETION = "DELETE FROM SC_QuestionReply_Recipient WHERE questionId in (SELECT id FROM SC_QuestionReply_Question WHERE instanceId = ?)";
    private static final String ANSWER_DELETION = "DELETE FROM SC_QuestionReply_Reply WHERE questionId in (SELECT id FROM SC_QuestionReply_Question WHERE instanceId = ?)";
    private static final String QUESTION_DELETION = "DELETE FROM SC_QuestionReply_Question WHERE instanceId = ?";

    @Transactional
    public void preDestroy(String componentInstanceId) {
        try (Connection connection = DBUtil.openConnection();){
            for (String sql : new String[]{RECIPIENT_DELETION, ANSWER_DELETION, QUESTION_DELETION}) {
                try (PreparedStatement deletion = connection.prepareStatement(sql);){
                    deletion.setString(1, componentInstanceId);
                    deletion.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

