/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import org.silverpeas.components.mydb.model.SqlTypes;
import org.silverpeas.components.mydb.service.MyDBRuntimeException;
import org.silverpeas.kernel.util.StringUtil;

public class TableFieldValue
implements Comparable<TableFieldValue> {
    private Object value;
    private final int type;

    public static TableFieldValue fromString(String value, int sqlType) {
        TableFieldValue tableFieldValue = new TableFieldValue(null, sqlType);
        tableFieldValue.update(value);
        return tableFieldValue;
    }

    TableFieldValue(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public boolean isText() {
        return SqlTypes.isText(this.type);
    }

    public boolean isEmpty() {
        return this.isText() && this.toString().isEmpty();
    }

    public void update(String value) {
        if (value == null || value.equals("null")) {
            this.value = null;
        } else if (SqlTypes.isText(this.type)) {
            this.value = value;
        } else if (SqlTypes.isDate(this.type)) {
            try {
                this.value = Date.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The date '" + value + "' is not in the database date escape format (yyyy-[m]m-[d]d)");
            }
        } else if (SqlTypes.isTime(this.type)) {
            this.value = Time.valueOf(value);
        } else if (SqlTypes.isTimestamp(this.type)) {
            this.value = Timestamp.valueOf(value);
        } else if (SqlTypes.isBoolean(this.type)) {
            this.value = StringUtil.getBooleanValue((String)value);
        } else if (SqlTypes.isBigInteger(this.type)) {
            this.value = BigInteger.valueOf(Long.parseLong(value));
        } else if (SqlTypes.isDecimal(this.type)) {
            this.value = BigDecimal.valueOf(Double.parseDouble(value));
        } else if (SqlTypes.isInteger(this.type)) {
            this.value = Integer.valueOf(value);
        } else if (SqlTypes.isFloat(this.type)) {
            this.value = Float.valueOf(value);
        } else if (SqlTypes.isDouble(this.type)) {
            this.value = Double.valueOf(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableFieldValue that = (TableFieldValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public int compareTo(TableFieldValue o) {
        int compare;
        if (this.type != o.type) {
            String typeName = JDBCType.valueOf(this.type).getName();
            throw new MyDBRuntimeException("The two table field values aren't of the same type: this is of type " + typeName + " whereas other if of type " + typeName);
        }
        if (o.value == null && this.value == null) {
            compare = 0;
        } else if (o.value != null && this.value instanceof Comparable) {
            compare = ((Comparable)this.value).compareTo(o.value);
        } else {
            if (o.value == null) {
                return 1;
            }
            if (this.value == null) {
                return -1;
            }
            compare = this.toString().compareTo(o.toString());
        }
        return compare;
    }

    Object toSQLObject() {
        return this.value;
    }

    public String toString() {
        return this.value == null ? "null" : this.value.toString();
    }

    public TableFieldValue getCopy() {
        return new TableFieldValue(this.value, this.type);
    }
}

