/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.mydb.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.silverpeas.components.mydb.model.MyDBConnectionInfo;
import org.silverpeas.components.mydb.model.predicates.AbstractColumnValuePredicate;
import org.silverpeas.components.mydb.service.MyDBException;
import org.silverpeas.components.mydb.service.MyDBRuntimeException;
import org.silverpeas.core.admin.PaginationPage;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.TransactionRuntimeException;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

class JdbcRequester {
    private final MyDBConnectionInfo currentConnectionInfo;

    JdbcRequester(MyDBConnectionInfo dsInfo) {
        this.currentConnectionInfo = dsInfo;
    }

    private boolean isDataSourceDefined() {
        return this.currentConnectionInfo.isDefined();
    }

    List<String> getTableNames() {
        List<String> list;
        block8: {
            Connection connection = this.currentConnectionInfo.openConnection();
            try {
                list = this.getTableNames(connection);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException | MyDBException e) {
                    throw new MyDBRuntimeException((Throwable)e);
                }
            }
            connection.close();
        }
        return list;
    }

    <T> T perform(DbOperation<T> operations) {
        Objects.requireNonNull(operations);
        if (!this.isDataSourceDefined()) {
            throw new MyDBRuntimeException("No data source defined!");
        }
        try {
            return (T)Transaction.performInOne(() -> {
                try (Connection connection = this.currentConnectionInfo.openConnection();){
                    Object t = operations.execute(this, connection);
                    return t;
                }
            });
        }
        catch (TransactionRuntimeException e) {
            throw new MyDBRuntimeException(e);
        }
    }

    private List<String> getTableNames(Connection connection) throws SQLException {
        Objects.requireNonNull(connection);
        ArrayList<String> tableNames = new ArrayList<String>();
        DatabaseMetaData dbMetaData = connection.getMetaData();
        ResultSet tables = dbMetaData.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
        while (tables.next()) {
            String table = tables.getString("TABLE_NAME");
            if (!this.isAuthorizedTable(connection, table)) continue;
            tableNames.add(table);
        }
        return tableNames;
    }

    private boolean isAuthorizedTable(Connection connection, String tableName) {
        try {
            JdbcSqlQuery.countAll().from(new String[]{tableName}).executeWith(connection);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    void loadColumns(Connection connection, String tableName, ColumnConsumer consumer) throws SQLException {
        Objects.requireNonNull(connection);
        DatabaseMetaData dbMetaData = connection.getMetaData();
        List<String> columnPks = this.getPrimaryKeys(connection, tableName, dbMetaData);
        Map<String, ForeignKeyDescriptor> columnFks = this.getForeignKeys(connection, tableName, dbMetaData);
        ResultSet columns = dbMetaData.getColumns(connection.getCatalog(), null, tableName, null);
        while (columns.next()) {
            String name = columns.getString("COLUMN_NAME");
            int type = columns.getInt("DATA_TYPE");
            int size = columns.getInt("COLUMN_SIZE");
            boolean isAutoIncremented = StringUtil.getBooleanValue((String)columns.getString("IS_AUTOINCREMENT"));
            boolean isNullable = StringUtil.getBooleanValue((String)columns.getString("IS_NULLABLE"));
            boolean isPrimaryKey = columnPks.contains(name);
            DefaultValue defaultValue = this.getDefaultValue(columns);
            consumer.accept(new ColumnDescriptor().withName(name).withType(type).withSize(size).withPrimaryKey(isPrimaryKey).withForeignKey(columnFks.get(name)).withNullable(isNullable).withAutoIncrement(isAutoIncremented).withDefaultValue(defaultValue));
        }
    }

    private Map<String, ForeignKeyDescriptor> getForeignKeys(Connection connection, String tableName, DatabaseMetaData dbMetaData) throws SQLException {
        LinkedHashMap<String, ForeignKeyDescriptor> columnFks = new LinkedHashMap<String, ForeignKeyDescriptor>(4);
        ResultSet foreignKeys = dbMetaData.getImportedKeys(connection.getCatalog(), connection.getSchema(), tableName);
        while (foreignKeys.next()) {
            String fkName = foreignKeys.getString("FK_NAME");
            String columnName = foreignKeys.getString("FKCOLUMN_NAME");
            String targetTableName = foreignKeys.getString("PKTABLE_NAME");
            String targetColumnName = foreignKeys.getString("PKCOLUMN_NAME");
            columnFks.put(columnName, new ForeignKeyDescriptor(fkName, targetTableName, targetColumnName));
        }
        return columnFks;
    }

    private List<String> getPrimaryKeys(Connection connection, String tableName, DatabaseMetaData dbMetaData) throws SQLException {
        ArrayList<String> columnPks = new ArrayList<String>(2);
        ResultSet primaryKeys = dbMetaData.getPrimaryKeys(connection.getCatalog(), connection.getSchema(), tableName);
        while (primaryKeys.next()) {
            String pk = primaryKeys.getString("COLUMN_NAME");
            columnPks.add(pk);
        }
        return columnPks;
    }

    <V, R> SilverpeasList<R> request(Connection connection, String tableName, AbstractColumnValuePredicate predicate, String orderBy, DataConverters<V, R> converters, PaginationPage pagination) throws SQLException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(predicate);
        JdbcSqlQuery query = JdbcSqlQuery.select((String)"*").from(new String[]{tableName});
        JdbcSqlQuery jdbcSqlQuery = query = StringUtil.isDefined((String)orderBy) ? predicate.apply(query).orderBy(new String[]{orderBy}) : predicate.apply(query);
        if (pagination != null) {
            query.withPagination(pagination.asCriterion());
        }
        return query.executeWith(connection, rs -> {
            try {
                LinkedHashMap row = new LinkedHashMap();
                ResultSetMetaData rsMetaData = rs.getMetaData();
                for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                    Object value = converters.getValueConverter().convert(rs.getObject(i), rs.getMetaData().getColumnType(i));
                    row.put(rsMetaData.getColumnName(i), value);
                }
                return converters.getRowConverter().convert(row);
            }
            catch (SQLException e) {
                throw new MyDBRuntimeException(e);
            }
        });
    }

    long delete(Connection connection, String tableName, Map<String, Object> criteria) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.deleteFrom((String)tableName);
        return this.applyCriteria(query, criteria).executeWith(connection);
    }

    long update(Connection connection, String tableName, Map<String, Object> values, Map<String, Object> criteria) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.update((String)tableName);
        values.forEach((arg_0, arg_1) -> ((JdbcSqlQuery)query).withUpdateParam(arg_0, arg_1));
        return this.applyCriteria(query, criteria).executeWith(connection);
    }

    void insert(Connection connection, String tableName, Map<String, Object> values) throws SQLException {
        JdbcSqlQuery query = JdbcSqlQuery.insertInto((String)tableName);
        values.forEach((arg_0, arg_1) -> ((JdbcSqlQuery)query).withInsertParam(arg_0, arg_1));
        query.executeWith(connection);
    }

    private JdbcSqlQuery applyCriteria(JdbcSqlQuery query, Map<String, Object> criteria) {
        StringBuilder clauses = new StringBuilder(criteria.size());
        ArrayList values = new ArrayList(criteria.size());
        String conjunction = " and ";
        criteria.forEach((key, value) -> {
            if (value == null) {
                clauses.append((String)key).append(" is null").append(" and ");
            } else {
                clauses.append((String)key).append(" = ?").append(" and ");
                values.add(value);
            }
        });
        clauses.setLength(clauses.length() - " and ".length());
        return query.where(clauses.toString(), values);
    }

    private DefaultValue getDefaultValue(ResultSet resultSet) throws SQLException {
        String defaultValue = resultSet.getString("COLUMN_DEF");
        return new DefaultValue(defaultValue);
    }

    @FunctionalInterface
    static interface ValueConverter<V> {
        public V convert(Object var1, int var2);
    }

    @FunctionalInterface
    static interface RowConverter<V, R> {
        public R convert(Map<String, V> var1);
    }

    @FunctionalInterface
    static interface ColumnConsumer {
        public void accept(ColumnDescriptor var1);
    }

    @FunctionalInterface
    static interface DbOperation<T> {
        public T execute(JdbcRequester var1, Connection var2) throws SQLException;
    }

    class ColumnDescriptor {
        private String name;
        private int type;
        private int size;
        private boolean primaryKey;
        private ForeignKeyDescriptor foreignKey;
        private boolean nullable;
        private boolean autoIncrementable;
        private DefaultValue defaultValue;

        private ColumnDescriptor() {
        }

        String getName() {
            return this.name;
        }

        private ColumnDescriptor withName(String name) {
            this.name = name;
            return this;
        }

        int getType() {
            return this.type;
        }

        private ColumnDescriptor withType(int type) {
            this.type = type;
            return this;
        }

        int getSize() {
            return this.size;
        }

        private ColumnDescriptor withSize(int size) {
            this.size = size;
            return this;
        }

        boolean isPrimaryKey() {
            return this.primaryKey;
        }

        private ColumnDescriptor withPrimaryKey(boolean primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        boolean isNullable() {
            return this.nullable;
        }

        private ColumnDescriptor withNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        boolean isAutoIncrementable() {
            return this.autoIncrementable;
        }

        private ColumnDescriptor withAutoIncrement(boolean isAutoIncrement) {
            this.autoIncrementable = isAutoIncrement;
            return this;
        }

        DefaultValue getDefaultValue() {
            return this.defaultValue;
        }

        private ColumnDescriptor withDefaultValue(DefaultValue defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        ForeignKeyDescriptor getForeignKey() {
            return this.foreignKey;
        }

        private ColumnDescriptor withForeignKey(ForeignKeyDescriptor foreignKey) {
            this.foreignKey = foreignKey;
            return this;
        }
    }

    class DefaultValue {
        private final String pattern;

        public DefaultValue(String valuePattern) {
            this.pattern = valuePattern;
        }

        public boolean isDefined() {
            return this.pattern != null;
        }

        public String get() {
            String value = null;
            if (this.isDefined()) {
                try (Connection connection = JdbcRequester.this.currentConnectionInfo.openConnection();){
                    value = this.computeSQLFunction(connection, this.pattern);
                }
                catch (SQLException | MyDBException e) {
                    throw new MyDBRuntimeException((Throwable)e);
                }
                int index = value.indexOf("::");
                if (index != -1) {
                    value = this.parseDefaultValue(value, index);
                }
            }
            return value;
        }

        @Nonnull
        private String parseDefaultValue(String defaultValue, int valueLength) {
            if ((defaultValue = defaultValue.substring(0, valueLength)).startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            return defaultValue;
        }

        @Nonnull
        private String computeSQLFunction(Connection connection, String function) {
            try {
                return (String)JdbcSqlQuery.select((String)function).executeUniqueWith(connection, r -> r.getString(1));
            }
            catch (SQLException e) {
                SilverLogger.getLogger((Object)this).silent((Throwable)e);
                return function;
            }
        }
    }

    static class ForeignKeyDescriptor {
        private final String name;
        private final String targetTableName;
        private final String targetColumnName;

        private ForeignKeyDescriptor(String name, String targetTableName, String targetColumnName) {
            this.name = name;
            this.targetTableName = targetTableName;
            this.targetColumnName = targetColumnName;
        }

        String getName() {
            return this.name;
        }

        String getTargetTableName() {
            return this.targetTableName;
        }

        String getTargetColumnName() {
            return this.targetColumnName;
        }
    }

    static class DataConverters<V, R> {
        private final ValueConverter<V> valueConverter;
        private final RowConverter<V, R> rowConverter;

        DataConverters(ValueConverter<V> valueConverter, RowConverter<V, R> rowConverter) {
            this.valueConverter = valueConverter;
            this.rowConverter = rowConverter;
        }

        ValueConverter<V> getValueConverter() {
            return this.valueConverter;
        }

        RowConverter<V, R> getRowConverter() {
            return this.rowConverter;
        }
    }
}

