/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import javax.inject.Inject;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.contribution.content.wysiwyg.notification.WysiwygEvent;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.LocalizedContribution;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.notification.system.CDIResourceEventListener;

@Bean
public class KmeliaWysiwygEventListener
extends CDIResourceEventListener<WysiwygEvent> {
    @Inject
    private KmeliaService kmeliaService;

    public void onUpdate(WysiwygEvent event) {
        WysiwygContent content = (WysiwygContent)event.getTransition().getAfter();
        if (content != null) {
            this.anExternalPublicationElementHaveChanged(content);
        }
    }

    public void onCreation(WysiwygEvent event) {
        this.onUpdate(event);
    }

    private void anExternalPublicationElementHaveChanged(WysiwygContent content) {
        if (this.isAboutKmeliaPublication(content)) {
            ContributionIdentifier id = content.getContribution().getIdentifier();
            PublicationPK pubPK = new PublicationPK(id.getLocalId(), id.getComponentInstanceId());
            this.kmeliaService.externalElementsOfPublicationHaveChanged(pubPK, content.getAuthor().getId());
        }
    }

    private boolean isAboutKmeliaPublication(WysiwygContent content) {
        LocalizedContribution contribution = content.getContribution();
        return !contribution.getIdentifier().getLocalId().startsWith("Node") && (contribution.getIdentifier().getComponentInstanceId().startsWith("kmax") || contribution.getIdentifier().getComponentInstanceId().startsWith("kmelia") || contribution.getIdentifier().getComponentInstanceId().startsWith("toolbox"));
    }
}

