/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.process.media;

import java.util.Collection;
import org.silverpeas.components.gallery.dao.MediaDAO;
import org.silverpeas.components.gallery.delegate.MediaDataUpdateDelegate;
import org.silverpeas.components.gallery.model.AlbumMedia;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.notification.AlbumMediaEventNotifier;
import org.silverpeas.components.gallery.process.AbstractGalleryDataProcess;
import org.silverpeas.core.contribution.content.form.PagesContext;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.process.management.ProcessExecutionContext;
import org.silverpeas.core.process.session.ProcessSession;
import org.silverpeas.kernel.util.StringUtil;

public class GalleryUpdateMediaDataProcess
extends AbstractGalleryDataProcess {
    private final MediaDataUpdateDelegate delegate;
    private final boolean updateTechnicalData;
    private final Media mediaBeforeChanges;
    private Collection<String> albumIds;

    public static GalleryUpdateMediaDataProcess getInstance(Media media) {
        return new GalleryUpdateMediaDataProcess(media, null, false);
    }

    public static GalleryUpdateMediaDataProcess getInstance(Media media, MediaDataUpdateDelegate delegate) {
        return new GalleryUpdateMediaDataProcess(media, delegate, true);
    }

    protected GalleryUpdateMediaDataProcess(Media media, MediaDataUpdateDelegate delegate, boolean updateTechnicalData) {
        super(media);
        this.delegate = delegate;
        this.updateTechnicalData = updateTechnicalData;
        this.mediaBeforeChanges = media.getCopy();
    }

    @Override
    protected void processData(ProcessExecutionContext context, ProcessSession session) throws Exception {
        if (this.delegate != null) {
            this.albumIds = MediaDAO.getAlbumIdsOf(this.getMedia());
            if (this.delegate.isHeaderData()) {
                this.delegate.updateHeader(this.getMedia());
            }
            if (this.delegate.isForm()) {
                String mediaId = this.getMedia().getId();
                PagesContext pageContext = new PagesContext("mediaForm", "0", this.delegate.getLanguage(), false, context.getComponentInstanceId(), context.getUser().getId(), this.delegate.getAlbumId());
                pageContext.setEncoding("UTF-8");
                pageContext.setObjectId(mediaId);
                if (this.delegate.isSkipEmptyValues()) {
                    pageContext.setUpdatePolicy(1);
                }
                this.delegate.updateForm(mediaId, pageContext);
            }
        }
        this.updateMedia(this.updateTechnicalData, context);
    }

    public void onSuccessful() throws Exception {
        super.onSuccessful();
        if (StringUtil.isDefined((String)this.mediaBeforeChanges.getId()) && this.albumIds != null) {
            AlbumMediaEventNotifier notifier = AlbumMediaEventNotifier.get();
            for (String albumId : this.albumIds) {
                notifier.notifyEventOn(ResourceEvent.Type.UPDATE, new AlbumMedia[]{new AlbumMedia(albumId, this.mediaBeforeChanges), new AlbumMedia(albumId, this.getMedia())});
            }
        }
    }
}

