/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.media;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.silverpeas.components.gallery.media.ExifProperty;
import org.silverpeas.components.gallery.media.IptcProperty;
import org.silverpeas.components.gallery.media.MediaMetadataExtractor;
import org.silverpeas.core.ui.DisplayI18NHelper;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractMediaMetadataExtractor
implements MediaMetadataExtractor {
    private static final SettingBundle DEFAULT_SETTINGS = ResourceLocator.getSettingBundle((String)"org.silverpeas.gallery.settings.metadataSettings");
    protected SettingBundle settings = DEFAULT_SETTINGS;
    protected Map<String, LocalizationBundle> metaDataBundles;
    protected List<ExifProperty> imageProperties;
    protected List<IptcProperty> imageIptcProperties;

    @Override
    public final List<ExifProperty> defineImageProperties(Iterable<String> propertyNames) {
        ArrayList<ExifProperty> properties = new ArrayList<ExifProperty>();
        for (String value : propertyNames) {
            String property;
            if (!value.startsWith("METADATA_") || (property = this.settings.getString(value + "_TAG")) == null) continue;
            String labelKey = this.settings.getString(value + "_LABEL");
            ExifProperty exifProperty = new ExifProperty(Integer.valueOf(property));
            for (Map.Entry<String, LocalizationBundle> labels : this.metaDataBundles.entrySet()) {
                String label = labels.getValue().getString(labelKey);
                exifProperty.setLabel(labels.getKey(), label);
            }
            properties.add(exifProperty);
        }
        return properties;
    }

    @Override
    public final List<IptcProperty> defineImageIptcProperties(Iterable<String> propertyNames) {
        ArrayList<IptcProperty> properties = new ArrayList<IptcProperty>();
        for (String value : propertyNames) {
            String property;
            if (!value.startsWith("IPTC_") || (property = this.settings.getString(value + "_TAG")) == null) continue;
            String labelKey = this.settings.getString(value + "_LABEL");
            boolean isDate = StringUtil.getBooleanValue((String)this.settings.getString(value + "_DATE"));
            IptcProperty iptcProperty = new IptcProperty(Integer.valueOf(property));
            for (Map.Entry<String, LocalizationBundle> labels : this.metaDataBundles.entrySet()) {
                String label = labels.getValue().getString(labelKey);
                iptcProperty.setLabel(labels.getKey(), label);
            }
            iptcProperty.setDate(isDate);
            properties.add(iptcProperty);
        }
        return properties;
    }

    final void init(String instanceId) {
        this.settings = ResourceLocator.getSettingBundle((String)("org.silverpeas.gallery.settings.metadataSettings_" + instanceId));
        if (!this.settings.exists()) {
            this.settings = DEFAULT_SETTINGS;
        }
        this.metaDataBundles = new HashMap<String, LocalizationBundle>(DisplayI18NHelper.getLanguages().size());
        for (String lang : DisplayI18NHelper.getLanguages()) {
            this.metaDataBundles.put(lang, ResourceLocator.getLocalizationBundle((String)"org.silverpeas.gallery.multilang.metadataBundle", (String)lang));
        }
        String display = this.settings.getString("display");
        Iterable propertyNames = StringUtil.splitString((String)display, (char)',');
        this.imageProperties = this.defineImageProperties(propertyNames);
        this.imageIptcProperties = this.defineImageIptcProperties(propertyNames);
    }
}

