/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.memory;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Splitter;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.JournalEntry;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;
import org.apache.jackrabbit.oak.plugins.document.cache.CacheInvalidationStats;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryDocumentStore
implements DocumentStore {
    private ConcurrentSkipListMap<String, NodeDocument> nodes = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, Document> clusterNodes = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, Document> settings = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, JournalEntry> externalChanges = new ConcurrentSkipListMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private Object lastReadWriteMode;
    private final Map<String, String> metadata = ImmutableMap.builder().put((Object)"type", (Object)"memory").build();
    private final boolean maintainModCount;
    private static final UpdateOp.Key KEY_MODIFIED = new UpdateOp.Key("_modified", null);

    public MemoryDocumentStore() {
        this(false);
    }

    public MemoryDocumentStore(boolean maintainModCount) {
        this.maintainModCount = maintainModCount;
    }

    @Override
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        return this.find(collection, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            Document document = (Document)map.get(key);
            return (T)document;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            SortedMap sub = map.subMap((Object)(fromKey + "\u0000"), (Object)toKey);
            ArrayList<Document> list = new ArrayList<Document>();
            for (Document doc : sub.values()) {
                if (indexedProperty != null) {
                    Object value = doc.get(indexedProperty);
                    if (value instanceof Boolean) {
                        long test;
                        long l = test = (Boolean)value != false ? 1L : 0L;
                        if (test < startValue) {
                            continue;
                        }
                    } else if (value instanceof Long) {
                        if ((Long)value < startValue) {
                            continue;
                        }
                    } else if (value != null) {
                        throw new DocumentStoreException("unexpected type for property " + indexedProperty + ": " + value.getClass());
                    }
                }
                list.add(doc);
                if (list.size() < limit) continue;
                break;
            }
            ArrayList<Document> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, String key) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.getMap(collection).remove(key);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.remove(collection, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, Map<String, Long> toRemove) {
        int num = 0;
        ConcurrentSkipListMap<String, T> map = this.getMap(collection);
        for (Map.Entry<String, Long> entry : toRemove.entrySet()) {
            Lock lock = this.rwLock.writeLock();
            lock.lock();
            try {
                Document doc = (Document)map.get(entry.getKey());
                UpdateOp.Condition c = UpdateOp.Condition.newEqualsCondition(entry.getValue());
                if (doc == null || !UpdateUtils.checkConditions(doc, Collections.singletonMap(KEY_MODIFIED, c)) || map.remove(entry.getKey()) == null) continue;
                ++num;
            }
            finally {
                lock.unlock();
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> int remove(Collection<T> collection, final String indexedProperty, final long startValue, final long endValue) throws DocumentStoreException {
        ConcurrentSkipListMap<String, T> map = this.getMap(collection);
        int num = map.size();
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            Maps.filterValues(map, (Predicate)new Predicate<T>(){

                public boolean apply(@Nullable T doc) {
                    Long modified = Utils.asLong((Number)((Document)doc).get(indexedProperty));
                    return startValue < modified && modified < endValue;
                }
            }).clear();
        }
        finally {
            lock.unlock();
        }
        return num -= map.size();
    }

    @Override
    @Nullable
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) {
        UpdateUtils.assertUnconditional(update);
        return this.internalCreateOrUpdate(collection, update, false);
    }

    @Override
    public <T extends Document> List<T> createOrUpdate(Collection<T> collection, List<UpdateOp> updateOps) {
        ArrayList<T> result = new ArrayList<T>(updateOps.size());
        for (UpdateOp update : updateOps) {
            result.add(this.createOrUpdate(collection, update));
        }
        return result;
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) {
        return this.internalCreateOrUpdate(collection, update, true);
    }

    @NotNull
    public MemoryDocumentStore copy() {
        MemoryDocumentStore copy = new MemoryDocumentStore();
        this.copyDocuments(Collection.NODES, copy);
        this.copyDocuments(Collection.CLUSTER_NODES, copy);
        this.copyDocuments(Collection.SETTINGS, copy);
        this.copyDocuments(Collection.JOURNAL, copy);
        return copy;
    }

    private <T extends Document> void copyDocuments(Collection<T> collection, MemoryDocumentStore target) {
        ConcurrentSkipListMap<String, T> from = this.getMap(collection);
        ConcurrentSkipListMap<String, T> to = target.getMap(collection);
        for (Map.Entry<String, T> entry : from.entrySet()) {
            T doc = collection.newDocument(target);
            ((Document)entry.getValue()).deepCopy((Document)doc);
            ((Document)doc).seal();
            to.put(entry.getKey(), doc);
        }
    }

    protected <T extends Document> ConcurrentSkipListMap<String, T> getMap(Collection<T> collection) {
        if (collection == Collection.NODES) {
            return this.nodes;
        }
        if (collection == Collection.CLUSTER_NODES) {
            return this.clusterNodes;
        }
        if (collection == Collection.SETTINGS) {
            return this.settings;
        }
        if (collection == Collection.JOURNAL) {
            return this.externalChanges;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T extends Document> T internalCreateOrUpdate(Collection<T> collection, UpdateOp update, boolean checkConditions) {
        ConcurrentSkipListMap<String, T> map = this.getMap(collection);
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            Document oldDoc = (Document)map.get(update.getId());
            T doc = collection.newDocument(this);
            if (oldDoc == null) {
                if (!update.isNew()) {
                    T t = null;
                    return t;
                }
            } else {
                oldDoc.deepCopy((Document)doc);
            }
            if (checkConditions && !UpdateUtils.checkConditions(doc, update.getConditions())) {
                T t = null;
                return t;
            }
            UpdateUtils.applyChanges(doc, update);
            this.maintainModCount((Document)doc);
            ((Document)doc).seal();
            map.put(update.getId(), doc);
            Document document = oldDoc;
            return (T)document;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            for (UpdateOp op : updateOps) {
                if (!map.containsKey(op.getId())) continue;
                boolean bl = false;
                return bl;
            }
            for (UpdateOp op : updateOps) {
                UpdateUtils.assertUnconditional(op);
                this.internalCreateOrUpdate(collection, op, false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Nodes:\n");
        for (String p : this.nodes.keySet()) {
            buff.append("Path: ").append(p).append('\n');
            NodeDocument doc = this.nodes.get(p);
            for (Map.Entry<String, Object> entry : doc.entrySet()) {
                buff.append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    public CacheInvalidationStats invalidateCache() {
        return null;
    }

    @Override
    public CacheInvalidationStats invalidateCache(Iterable<String> keys) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        return this.find(collection, key);
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        if (readWriteMode == null || readWriteMode.equals(this.lastReadWriteMode)) {
            return;
        }
        this.lastReadWriteMode = readWriteMode;
        try {
            WriteConcern writeConcern;
            String write;
            ReadPreference readPref;
            Map map = Splitter.on((String)", ").withKeyValueSeparator(":").split((CharSequence)readWriteMode);
            String read = (String)map.get("read");
            if (read != null && !(readPref = ReadPreference.valueOf((String)read)).equals(this.readPreference)) {
                this.readPreference = readPref;
            }
            if ((write = (String)map.get("write")) != null && !(writeConcern = WriteConcern.valueOf((String)write)).equals((Object)this.writeConcern)) {
                this.writeConcern = writeConcern;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Iterable<CacheStats> getCacheStats() {
        return null;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public Map<String, String> getStats() {
        return ImmutableMap.builder().put((Object)Collection.NODES.toString(), (Object)String.valueOf(this.nodes.size())).put((Object)Collection.CLUSTER_NODES.toString(), (Object)String.valueOf(this.clusterNodes.size())).put((Object)Collection.SETTINGS.toString(), (Object)String.valueOf(this.settings.size())).put((Object)Collection.JOURNAL.toString(), (Object)String.valueOf(this.externalChanges.size())).build();
    }

    @Override
    public long determineServerTimeDifferenceMillis() {
        return 0L;
    }

    private void maintainModCount(Document doc) {
        if (!this.maintainModCount) {
            return;
        }
        Long modCount = doc.getModCount();
        if (modCount == null) {
            modCount = 0L;
        }
        doc.put("_modCount", modCount + 1L);
    }
}

