/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.bundlor;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.plugins.document.bundlor.Matcher;

class CompositeMatcher
implements Matcher {
    private final List<Matcher> matchers;

    public static Matcher compose(List<Matcher> matchers) {
        switch (matchers.size()) {
            case 0: {
                return Matcher.NON_MATCHING;
            }
            case 1: {
                return matchers.get(0);
            }
        }
        return new CompositeMatcher(matchers);
    }

    private CompositeMatcher(List<Matcher> matchers) {
        for (Matcher m : matchers) {
            Preconditions.checkArgument((boolean)m.isMatch(), (String)"Non matching matcher found in [%s]", matchers);
        }
        this.matchers = matchers;
    }

    @Override
    public Matcher next(String name) {
        ArrayList nextSet = Lists.newArrayListWithCapacity((int)this.matchers.size());
        for (Matcher current : this.matchers) {
            Matcher next = current.next(name);
            if (!next.isMatch()) continue;
            nextSet.add(next);
        }
        return CompositeMatcher.compose(nextSet);
    }

    @Override
    public boolean isMatch() {
        return true;
    }

    @Override
    public String getMatchedPath() {
        return this.matchers.get(0).getMatchedPath();
    }

    @Override
    public int depth() {
        return this.matchers.get(0).depth();
    }

    @Override
    public boolean matchesAllChildren() {
        for (Matcher m : this.matchers) {
            if (!m.matchesAllChildren()) continue;
            return true;
        }
        return false;
    }
}

