/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.tool;

import java.io.File;
import java.io.IOException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.backup.FileStoreBackup;
import org.apache.jackrabbit.oak.backup.impl.FileStoreBackupImpl;
import org.apache.jackrabbit.oak.segment.file.InvalidFileStoreVersionException;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.tool.Utils;

public class Backup {
    private final File source;
    private final File target;
    private final boolean fakeBlobStore;
    private final FileStoreBackup fileStoreBackup;

    public static Builder builder() {
        return new Builder();
    }

    private Backup(Builder builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.fakeBlobStore = builder.fakeBlobStore;
        this.fileStoreBackup = builder.fileStoreBackup;
    }

    public int run() {
        ReadOnlyFileStore fs = this.newFileStore();
        try {
            this.fileStoreBackup.backup(fs.getReader(), fs.getRevisions(), this.target);
            int n = 0;
            if (fs != null) {
                fs.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return 1;
            }
        }
    }

    private ReadOnlyFileStore newFileStore() throws IOException, InvalidFileStoreVersionException {
        if (this.fakeBlobStore) {
            return Utils.openReadOnlyFileStore(this.source, Utils.newBasicReadOnlyBlobStore());
        }
        return Utils.openReadOnlyFileStore(this.source);
    }

    public static class Builder {
        private File source;
        private File target;
        private boolean fakeBlobStore = FileStoreBackupImpl.USE_FAKE_BLOBSTORE;
        private final FileStoreBackup fileStoreBackup = new FileStoreBackupImpl();

        private Builder() {
        }

        public Builder withSource(File source) {
            this.source = (File)Preconditions.checkNotNull((Object)source);
            return this;
        }

        public Builder withTarget(File target) {
            this.target = (File)Preconditions.checkNotNull((Object)target);
            return this;
        }

        public Builder withFakeBlobStore(boolean fakeBlobStore) {
            this.fakeBlobStore = fakeBlobStore;
            return this;
        }

        public Backup build() {
            Preconditions.checkNotNull((Object)this.source);
            Preconditions.checkNotNull((Object)this.target);
            return new Backup(this);
        }
    }
}

