/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.split;

import java.io.IOException;
import java.util.Optional;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFileReader;

public class SplitJournalFileReader
implements JournalFileReader {
    private final JournalFileReader roJournalReader;
    private final JournalFileReader rwJournalReader;
    private final Optional<String> lastRoJournalEntry;
    private boolean rwJournalReaderHasFinished;
    private boolean roJournalReaderHasFinished;

    public SplitJournalFileReader(JournalFileReader roJournalReader, JournalFileReader rwJournalReader, Optional<String> lastRoJournalEntry) {
        this.roJournalReader = roJournalReader;
        this.rwJournalReader = rwJournalReader;
        this.lastRoJournalEntry = lastRoJournalEntry;
    }

    @Override
    public String readLine() throws IOException {
        String line;
        if (!this.rwJournalReaderHasFinished) {
            line = this.rwJournalReader.readLine();
            if (line != null) {
                return line;
            }
            this.rwJournalReaderHasFinished = true;
            if (this.lastRoJournalEntry.isPresent()) {
                this.rewindToLine(this.roJournalReader, this.lastRoJournalEntry.get());
                return this.lastRoJournalEntry.get();
            }
            this.roJournalReaderHasFinished = true;
        }
        if (!this.roJournalReaderHasFinished) {
            line = this.roJournalReader.readLine();
            if (line != null) {
                return line;
            }
            this.roJournalReaderHasFinished = true;
        }
        return null;
    }

    private void rewindToLine(JournalFileReader reader, String stopLine) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && !line.equals(stopLine)) {
        }
    }

    @Override
    public void close() throws IOException {
        this.roJournalReader.close();
        this.rwJournalReader.close();
    }
}

