/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.segment.SegmentNodeStoreStatsMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Configuration.class)
public class SegmentNodeStoreMonitorService {
    @Reference
    private SegmentNodeStoreStatsMBean snsStatsMBean;

    @Activate
    public void activate(Configuration config) {
        this.snsStatsMBean.setWriterGroupsForLastMinuteCounts(PropertiesUtil.toStringArray((Object)config.commitsTrackerWriterGroups(), null));
    }

    @ObjectClassDefinition(name="Oak Segment Tar Monitoring service", description="This service is responsible for different configurations related to Oak Segment Tar read/write monitoring.")
    static @interface Configuration {
        @AttributeDefinition(name="Writer groups", description="Writer groups for which commits are tracked individually")
        public String[] commitsTrackerWriterGroups() default {};
    }
}

