/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.base.Supplier;
import org.apache.jackrabbit.guava.common.cache.CacheStats;
import org.apache.jackrabbit.guava.common.cache.Weigher;
import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.jetbrains.annotations.NotNull;

public abstract class RecordCache<K>
implements Cache<K, RecordId> {
    private long hitCount;
    private long missCount;
    private long loadCount;
    private long evictionCount;

    public abstract long size();

    public abstract long estimateCurrentWeight();

    @Override
    public void put(@NotNull K key, @NotNull RecordId value, byte cost) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public CacheStats getStats() {
        return new CacheStats(this.hitCount, this.missCount, this.loadCount, 0L, 0L, this.evictionCount);
    }

    @NotNull
    public static <T> RecordCache<T> newRecordCache(int size) {
        if (size <= 0) {
            return new Empty();
        }
        return new Default(size, CacheWeights.noopWeigher());
    }

    @NotNull
    public static <T> Supplier<RecordCache<T>> factory(int size, @NotNull Weigher<T, RecordId> weigher) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, (Weigher)Preconditions.checkNotNull(weigher));
    }

    @NotNull
    public static <T> Supplier<RecordCache<T>> factory(int size) {
        if (size <= 0) {
            return Empty.emptyFactory();
        }
        return Default.defaultFactory(size, CacheWeights.noopWeigher());
    }

    private static class Default<K>
    extends RecordCache<K> {
        @NotNull
        private final Map<K, RecordId> records;
        @NotNull
        private final Weigher<K, RecordId> weigher;
        private long weight = 0L;

        static final <K> Supplier<RecordCache<K>> defaultFactory(final int size, final @NotNull Weigher<K, RecordId> weigher) {
            return new Supplier<RecordCache<K>>(){

                public RecordCache<K> get() {
                    return new Default(size, (Weigher)Preconditions.checkNotNull((Object)weigher));
                }
            };
        }

        Default(final int size, final @NotNull Weigher<K, RecordId> weigher) {
            this.weigher = (Weigher)Preconditions.checkNotNull(weigher);
            this.records = new LinkedHashMap<K, RecordId>(size * 4 / 3, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, RecordId> eldest) {
                    boolean remove;
                    boolean bl = remove = super.size() > size;
                    if (remove) {
                        evictionCount++;
                        weight -= (long)weigher.weigh(eldest.getKey(), (Object)eldest.getValue());
                    }
                    return remove;
                }
            };
        }

        @Override
        public synchronized void put(@NotNull K key, @NotNull RecordId value) {
            ++this.loadCount;
            this.records.put(key, value);
            this.weight += (long)this.weigher.weigh(key, (Object)value);
        }

        @Override
        public synchronized RecordId get(@NotNull K key) {
            RecordId value = this.records.get(key);
            if (value == null) {
                ++this.missCount;
            } else {
                ++this.hitCount;
            }
            return value;
        }

        @Override
        public synchronized long size() {
            return this.records.size();
        }

        @Override
        public long estimateCurrentWeight() {
            return this.weight;
        }
    }

    private static class Empty<T>
    extends RecordCache<T> {
        private Empty() {
        }

        static final <T> Supplier<RecordCache<T>> emptyFactory() {
            return new Supplier<RecordCache<T>>(){

                public RecordCache<T> get() {
                    return new Empty();
                }
            };
        }

        @Override
        public synchronized void put(@NotNull T key, @NotNull RecordId value) {
        }

        @Override
        public synchronized RecordId get(@NotNull T key) {
            ++this.missCount;
            return null;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public long estimateCurrentWeight() {
            return -1L;
        }
    }
}

