/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.security.user.AdminPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.SystemUserPrincipalImpl;
import org.apache.jackrabbit.oak.security.user.UserImpl;
import org.apache.jackrabbit.oak.security.user.UserManagerImpl;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SystemUserImpl
extends UserImpl {
    SystemUserImpl(@NotNull String id, @NotNull Tree tree, @NotNull UserManagerImpl userManager) throws RepositoryException {
        super(id, tree, userManager);
    }

    @Override
    void checkValidTree(@NotNull Tree tree) throws RepositoryException {
        super.checkValidTree(tree);
        if (!UserUtil.isSystemUser((Tree)tree)) {
            throw new IllegalArgumentException("Invalid user node: node type rep:SystemUser expected.");
        }
    }

    @Override
    @NotNull
    public Principal getPrincipal() throws RepositoryException {
        if (this.isAdmin()) {
            return new AdminPrincipalImpl(this.getPrincipalName(), this.getTree(), this.getUserManager().getNamePathMapper());
        }
        return new SystemUserPrincipalImpl(this.getPrincipalName(), this.getTree(), this.getUserManager().getNamePathMapper());
    }

    @Override
    public boolean isSystemUser() {
        return true;
    }

    @Override
    public void changePassword(@Nullable String password) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("system user");
    }

    @Override
    public void changePassword(@Nullable String password, @NotNull String oldPassword) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException("system user");
    }
}

