/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user;

import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.base.Predicates;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.user.Utils;
import org.apache.jackrabbit.oak.spi.security.principal.EveryonePrincipal;
import org.apache.jackrabbit.oak.spi.security.user.DynamicMembershipProvider;
import org.jetbrains.annotations.NotNull;

class EveryoneMembershipProvider
implements DynamicMembershipProvider {
    private final UserManager userManager;
    private final String repPrincipalName;

    EveryoneMembershipProvider(@NotNull UserManager userManager, @NotNull NamePathMapper namePathMapper) {
        this.userManager = userManager;
        this.repPrincipalName = namePathMapper.getJcrName("rep:principalName");
    }

    public boolean coversAllMembers(@NotNull Group group) {
        return Utils.isEveryone((Authorizable)group);
    }

    @NotNull
    public Iterator<Authorizable> getMembers(@NotNull Group group, boolean includeInherited) throws RepositoryException {
        if (Utils.isEveryone((Authorizable)group)) {
            UnmodifiableIterator result = Iterators.filter((Iterator)this.userManager.findAuthorizables(this.repPrincipalName, null, 3), (Predicate)Predicates.notNull());
            return Iterators.filter((Iterator)result, authorizable -> !Utils.isEveryone(authorizable));
        }
        return RangeIteratorAdapter.EMPTY;
    }

    public boolean isMember(@NotNull Group group, @NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        return Utils.isEveryone((Authorizable)group);
    }

    @NotNull
    public Iterator<Group> getMembership(@NotNull Authorizable authorizable, boolean includeInherited) throws RepositoryException {
        Authorizable everyoneGroup = this.userManager.getAuthorizable((Principal)EveryonePrincipal.getInstance());
        if (everyoneGroup instanceof Group) {
            return new RangeIteratorAdapter(Collections.singleton((Group)everyoneGroup));
        }
        return RangeIteratorAdapter.EMPTY;
    }
}

