/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.gradle.internal.classpath.Instrumented;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrincipalPermissionEntries {
    private static int MAX_SIZE = Instrumented.getInteger((String)"oak.PrincipalPermissionEntries.maxSize", (int)1000, (String)"org.apache.jackrabbit.oak.security.authorization.permission.PrincipalPermissionEntries");
    private final long expectedSize;
    private boolean fullyLoaded;
    private Map<String, Collection<PermissionEntry>> entries = new HashMap<String, Collection<PermissionEntry>>();
    private final Map<String, Boolean> emptyPaths;

    PrincipalPermissionEntries() {
        this(Long.MAX_VALUE);
    }

    PrincipalPermissionEntries(long expectedSize) {
        this.expectedSize = expectedSize;
        this.fullyLoaded = expectedSize == 0L;
        this.emptyPaths = new LinkedHashMap<String, Boolean>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
                return this.size() > MAX_SIZE;
            }
        };
    }

    long getSize() {
        return this.entries.size() + this.emptyPaths.size();
    }

    boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    @NotNull
    Map<String, Collection<PermissionEntry>> getEntries() {
        return this.entries;
    }

    @Nullable
    Collection<PermissionEntry> getEntriesByPath(@NotNull String path) {
        return this.emptyPaths.containsKey(path) ? Collections.emptySet() : this.entries.get(path);
    }

    void putEntriesByPath(@NotNull String path, @NotNull Collection<PermissionEntry> pathEntries) {
        this.entries.put(path, pathEntries);
        if ((long)this.entries.size() >= this.expectedSize) {
            this.setFullyLoaded(true);
        }
    }

    void rememberNotAccessControlled(@NotNull String path) {
        this.emptyPaths.put(path, null);
    }

    void putAllEntries(@NotNull Map<String, Collection<PermissionEntry>> allEntries) {
        this.entries.putAll(allEntries);
        this.setFullyLoaded(true);
    }
}

