/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentIdProvider;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.FileStoreUtil;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyRevisions
implements Revisions,
Closeable {
    @NotNull
    private final AtomicReference<RecordId> head;
    @NotNull
    private final JournalFile journalFile;

    public ReadOnlyRevisions(@NotNull SegmentNodeStorePersistence persistence) {
        this.journalFile = ((SegmentNodeStorePersistence)Preconditions.checkNotNull((Object)persistence)).getJournalFile();
        this.head = new AtomicReference<Object>(null);
    }

    synchronized void bind(@NotNull SegmentStore store, @NotNull SegmentIdProvider idProvider) throws IOException {
        if (this.head.get() != null) {
            return;
        }
        RecordId persistedId = FileStoreUtil.findPersistedRecordId(store, idProvider, this.journalFile);
        if (persistedId == null) {
            throw new IllegalStateException("Cannot start readonly store from empty journal");
        }
        this.head.set(persistedId);
    }

    private void checkBound() {
        Preconditions.checkState((this.head.get() != null ? 1 : 0) != 0, (Object)"Revisions not bound to a store");
    }

    @Override
    @NotNull
    public RecordId getHead() {
        this.checkBound();
        return this.head.get();
    }

    @Override
    @NotNull
    public RecordId getPersistedHead() {
        return this.getHead();
    }

    @Override
    public boolean setHead(@NotNull RecordId expected, @NotNull RecordId head, Revisions.Option ... options) {
        this.checkBound();
        RecordId id = this.head.get();
        return id.equals(expected) && this.head.compareAndSet(id, head);
    }

    @Override
    public RecordId setHead(@NotNull Function<RecordId, RecordId> newHead, Revisions.Option ... options) throws InterruptedException {
        throw new UnsupportedOperationException("ReadOnly Revisions");
    }

    @Override
    public void close() throws IOException {
    }
}

