/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.security.Principal;
import java.util.Date;
import javax.jcr.Credentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.api.security.authentication.token.TokenCredentials;
import org.apache.jackrabbit.oak.security.authentication.token.TokenProviderImpl;
import org.apache.jackrabbit.oak.spi.security.authentication.Authentication;
import org.apache.jackrabbit.oak.spi.security.authentication.LoginModuleMonitor;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenCredentialsExpiredException;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenInfo;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TokenAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(TokenAuthentication.class);
    private final TokenProvider tokenProvider;
    private final LoginModuleMonitor monitor;
    private TokenInfo tokenInfo;

    TokenAuthentication(@NotNull TokenProvider tokenProvider, @NotNull LoginModuleMonitor monitor) {
        this.tokenProvider = tokenProvider;
        this.monitor = monitor;
    }

    public boolean authenticate(@Nullable Credentials credentials) throws LoginException {
        if (credentials instanceof TokenCredentials) {
            TokenCredentials tc = (TokenCredentials)credentials;
            if (!this.validateCredentials(tc)) {
                LoginException le = new LoginException("Invalid token credentials.");
                this.monitor.loginFailed(le, (Credentials)tc);
                throw le;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public String getUserId() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("UserId can only be retrieved after successful authentication.");
        }
        return this.tokenInfo.getUserId();
    }

    @Nullable
    public Principal getUserPrincipal() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("Token info can only be retrieved after successful authentication.");
        }
        if (this.tokenInfo instanceof TokenProviderImpl.TokenInfoImpl) {
            return ((TokenProviderImpl.TokenInfoImpl)this.tokenInfo).getPrincipal();
        }
        return null;
    }

    @NotNull
    TokenInfo getTokenInfo() {
        if (this.tokenInfo == null) {
            throw new IllegalStateException("Token info can only be retrieved after successful authentication.");
        }
        return this.tokenInfo;
    }

    private boolean validateCredentials(@NotNull TokenCredentials tokenCredentials) throws TokenCredentialsExpiredException {
        String token = tokenCredentials.getToken();
        this.tokenInfo = this.tokenProvider.getTokenInfo(token);
        if (this.tokenInfo == null) {
            log.debug("No valid TokenInfo for token.");
            return false;
        }
        long loginTime = new Date().getTime();
        if (this.tokenInfo.isExpired(loginTime)) {
            String msg = "Token is expired";
            log.debug(msg);
            this.tokenInfo.remove();
            TokenCredentialsExpiredException tce = new TokenCredentialsExpiredException(msg);
            this.monitor.loginFailed((LoginException)tce, (Credentials)tokenCredentials);
            throw tce;
        }
        if (this.tokenInfo.matches(tokenCredentials)) {
            if (tokenCredentials.getAttribute("tokenSkipRefresh") == null) {
                boolean reset = this.tokenInfo.resetExpiration(loginTime);
                log.debug("Token reset={}", (Object)reset);
            } else {
                log.debug("Token reset skipped.");
            }
            return true;
        }
        return false;
    }
}

