/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.cursor;

import java.util.Iterator;
import org.apache.jackrabbit.guava.common.base.Function;
import org.apache.jackrabbit.guava.common.base.Predicate;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.guava.common.collect.UnmodifiableIterator;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.jetbrains.annotations.Nullable;

class AncestorCursor
extends PathCursor {
    public AncestorCursor(Cursor cursor, int level, QueryLimits settings) {
        super(AncestorCursor.transform(cursor, level), true, settings);
    }

    private static Iterator<String> transform(Cursor cursor, final int level) {
        Iterator unfiltered = Iterators.transform((Iterator)cursor, (Function)new Function<IndexRow, String>(){

            public String apply(@Nullable IndexRow input) {
                return input != null ? input.getPath() : null;
            }
        });
        UnmodifiableIterator filtered = Iterators.filter((Iterator)unfiltered, (Predicate)new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                return input != null && PathUtils.getDepth((String)input) >= level;
            }
        });
        return Iterators.transform((Iterator)filtered, (Function)new Function<String, String>(){

            public String apply(String input) {
                return PathUtils.getAncestorPath((String)input, (int)level);
            }
        });
    }
}

