/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoException;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import java.util.TreeSet;
import org.apache.jackrabbit.guava.common.collect.ImmutableList;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MongoDocumentStoreMetrics
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDocumentStoreMetrics.class);
    private static final ImmutableList<Collection<? extends Document>> COLLECTIONS = ImmutableList.of(Collection.NODES, Collection.JOURNAL, Collection.CLUSTER_NODES, Collection.SETTINGS, Collection.BLOBS);
    private final MongoDatabase db;
    private final StatisticsProvider statsProvider;

    public MongoDocumentStoreMetrics(MongoDocumentStore store, StatisticsProvider statsProvider) {
        this.db = store.getDatabase();
        this.statsProvider = statsProvider;
    }

    @Override
    public void run() {
        this.updateCounters();
    }

    private void updateCounters() {
        LOG.debug("Updating counters");
        try {
            TreeSet collectionNames = new TreeSet();
            this.db.listCollectionNames().into(collectionNames);
            for (Collection c : COLLECTIONS) {
                if (!collectionNames.contains(c.toString())) {
                    LOG.debug("Collection {} does not exist", (Object)c);
                    continue;
                }
                CollectionStats stats = this.getStats(c);
                this.updateCounter(this.getCounter(c, "count"), stats.count);
                this.updateCounter(this.getCounter(c, "size"), stats.size);
                this.updateCounter(this.getCounter(c, "storageSize"), stats.storageSize);
                this.updateCounter(this.getCounter(c, "totalIndexSize"), stats.totalIndexSize);
            }
            DatabaseStats dbStats = this.getDBStats();
            this.updateCounter(this.getDBCounter("fsUsedSize"), dbStats.fsUsedSize);
            this.updateCounter(this.getDBCounter("fsTotalSize"), dbStats.fsTotalSize);
        }
        catch (MongoException e) {
            LOG.warn("Updating counters failed: {}", (Object)e.toString());
        }
    }

    private void updateCounter(CounterStats counter, long value) {
        counter.inc(value - counter.getCount());
    }

    private CollectionStats getStats(Collection<? extends Document> c) throws MongoException {
        CollectionStats stats = new CollectionStats();
        BasicDBObject result = new BasicDBObject((Map)this.db.runCommand((Bson)new org.bson.Document("collStats", (Object)c.toString())));
        stats.count = result.getLong("count", 0L);
        stats.size = result.getLong("size", 0L);
        stats.storageSize = result.getLong("storageSize", 0L);
        stats.totalIndexSize = result.getLong("totalIndexSize", 0L);
        return stats;
    }

    private DatabaseStats getDBStats() throws MongoException {
        DatabaseStats stats = new DatabaseStats();
        BasicDBObject result = new BasicDBObject((Map)this.db.runCommand((Bson)new org.bson.Document("dbStats", (Object)1)));
        stats.fsUsedSize = result.getLong("fsUsedSize", 0L);
        stats.fsTotalSize = result.getLong("fsTotalSize", 0L);
        return stats;
    }

    private CounterStats getCounter(Collection<? extends Document> c, String name) {
        String counterName = "MongoDB." + c.toString() + "." + name;
        return this.statsProvider.getCounterStats(counterName, StatsOptions.METRICS_ONLY);
    }

    private CounterStats getDBCounter(String name) {
        String counterName = "MongoDB." + name;
        return this.statsProvider.getCounterStats(counterName, StatsOptions.METRICS_ONLY);
    }

    private static final class DatabaseStats {
        long fsUsedSize;
        long fsTotalSize;

        private DatabaseStats() {
        }
    }

    private static final class CollectionStats {
        long count;
        long size;
        long storageSize;
        long totalIndexSize;

        private CollectionStats() {
        }
    }
}

