/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Document
implements CacheValue {
    public static final String ID = "_id";
    public static final String MOD_COUNT = "_modCount";
    protected Map<String, Object> data = Maps.newHashMap();
    private AtomicBoolean sealed = new AtomicBoolean(false);

    @Nullable
    public String getId() {
        return (String)this.get(ID);
    }

    @Nullable
    public Long getModCount() {
        return Utils.asLong((Number)this.get(MOD_COUNT));
    }

    @Nullable
    public Object get(String key) {
        return this.data.get(key);
    }

    @Nullable
    public Object put(String key, Object value) {
        return this.data.put(key, value);
    }

    @Nullable
    public Object remove(String key) {
        return this.data.remove(key);
    }

    public Set<String> keySet() {
        return this.data.keySet();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.data.entrySet();
    }

    public void seal() {
        if (!this.sealed.getAndSet(true)) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                Map map = (Map)entry.getValue();
                entry.setValue(this.transformAndSeal(map, entry.getKey(), 1));
            }
            this.data = Collections.unmodifiableMap(this.data);
        }
    }

    public boolean isSealed() {
        return this.sealed.get();
    }

    public void deepCopy(Document target) {
        Utils.deepCopyMap(this.data, target.data);
    }

    public String format() {
        return this.data.toString().replaceAll(", _", ",\n_").replaceAll("}, ", "},\n");
    }

    public int getMemory() {
        return Utils.estimateMemoryUsage(this.data);
    }

    @NotNull
    protected Map<?, ?> transformAndSeal(@NotNull Map<Object, Object> map, @Nullable String key, int level) {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof Map)) continue;
            Map childMap = (Map)value;
            entry.setValue(this.transformAndSeal(childMap, entry.getKey().toString(), level + 1));
        }
        if (map instanceof NavigableMap) {
            return Maps.unmodifiableNavigableMap((NavigableMap)((NavigableMap)map));
        }
        return Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.getId();
    }
}

