/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.security.authorization.ProviderCtx;
import org.apache.jackrabbit.oak.security.authorization.permission.MountPermissionProvider;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionStoreEditor;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.PostValidationHook;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBitsProvider;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.jetbrains.annotations.NotNull;

public class PermissionHook
implements PostValidationHook,
AccessControlConstants,
PermissionConstants {
    private final RestrictionProvider restrictionProvider;
    private final String workspaceName;
    private final ProviderCtx providerCtx;
    private NodeBuilder permissionStore;
    private PrivilegeBitsProvider bitsProvider;
    private TypePredicate isACL;
    private TypePredicate isACE;
    private TypePredicate isGrantACE;
    private Map<String, PermissionStoreEditor> modified = new HashMap<String, PermissionStoreEditor>();
    private Map<String, PermissionStoreEditor> deleted = new HashMap<String, PermissionStoreEditor>();

    public PermissionHook(@NotNull String workspaceName, @NotNull RestrictionProvider restrictionProvider, @NotNull ProviderCtx providerCtx) {
        this.workspaceName = workspaceName;
        this.restrictionProvider = restrictionProvider;
        this.providerCtx = providerCtx;
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) {
        NodeBuilder rootAfter = after.builder();
        this.permissionStore = PermissionHook.getPermissionStore(rootAfter);
        this.bitsProvider = new PrivilegeBitsProvider(this.providerCtx.getRootProvider().createReadOnlyRoot(after));
        this.isACL = new TypePredicate(after, "rep:ACL");
        this.isACE = new TypePredicate(after, "rep:ACE");
        this.isGrantACE = new TypePredicate(after, "rep:GrantACE");
        Diff diff = new Diff("");
        after.compareAgainstBaseState(before, (NodeStateDiff)diff);
        this.apply();
        return rootAfter.getNodeState();
    }

    public String toString() {
        return "PermissionHook";
    }

    private void apply() {
        for (Map.Entry<String, PermissionStoreEditor> entry : this.deleted.entrySet()) {
            entry.getValue().removePermissionEntries();
        }
        for (Map.Entry<String, PermissionStoreEditor> entry : this.modified.entrySet()) {
            entry.getValue().updatePermissionEntries();
        }
        this.modified.clear();
        this.deleted.clear();
    }

    @NotNull
    private static NodeBuilder getPermissionStore(@NotNull NodeBuilder rootBuilder) {
        return rootBuilder.getChildNode("jcr:system").getChildNode("rep:permissionStore");
    }

    @NotNull
    private NodeBuilder getPermissionRoot(@NotNull String path) {
        Mount m = this.providerCtx.getMountInfoProvider().getMountByPath(path);
        return this.permissionStore.getChildNode(MountPermissionProvider.getPermissionRootName(m, this.workspaceName));
    }

    private final class Diff
    extends DefaultNodeStateDiff {
        private final String parentPath;

        private Diff(String parentPath) {
            this.parentPath = parentPath;
        }

        public boolean childNodeAdded(String name, NodeState after) {
            if (NodeStateUtils.isHidden((String)name)) {
                return true;
            }
            String path = this.parentPath + "/" + name;
            if (PermissionHook.this.isACL.test(after)) {
                PermissionStoreEditor psEditor = this.createPermissionStoreEditor(name, after);
                PermissionHook.this.modified.put(psEditor.getPath(), psEditor);
            } else {
                after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)new Diff(path));
            }
            return true;
        }

        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            if (NodeStateUtils.isHidden((String)name)) {
                return true;
            }
            String path = this.parentPath + "/" + name;
            if (PermissionHook.this.isACL.test(before)) {
                if (PermissionHook.this.isACL.test(after)) {
                    PermissionStoreEditor psEditor = this.createPermissionStoreEditor(name, after);
                    PermissionHook.this.modified.put(psEditor.getPath(), psEditor);
                    PermissionStoreEditor beforeEditor = this.createPermissionStoreEditor(name, before);
                    beforeEditor.removePermissionEntries(psEditor);
                    if (!beforeEditor.isEmpty()) {
                        PermissionHook.this.deleted.put(this.parentPath, beforeEditor);
                    }
                } else {
                    PermissionStoreEditor psEditor = this.createPermissionStoreEditor(name, before);
                    PermissionHook.this.deleted.put(psEditor.getPath(), psEditor);
                }
            } else if (PermissionHook.this.isACL.test(after)) {
                PermissionStoreEditor psEditor = this.createPermissionStoreEditor(name, after);
                PermissionHook.this.modified.put(psEditor.getPath(), psEditor);
            } else {
                after.compareAgainstBaseState(before, (NodeStateDiff)new Diff(path));
            }
            return true;
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            if (NodeStateUtils.isHidden((String)name)) {
                return true;
            }
            String path = this.parentPath + "/" + name;
            if (PermissionHook.this.isACL.test(before)) {
                PermissionStoreEditor psEditor = this.createPermissionStoreEditor(name, before);
                PermissionHook.this.deleted.put(psEditor.getPath(), psEditor);
            } else {
                EmptyNodeState.EMPTY_NODE.compareAgainstBaseState(before, (NodeStateDiff)new Diff(path));
            }
            return true;
        }

        @NotNull
        private PermissionStoreEditor createPermissionStoreEditor(@NotNull String nodeName, @NotNull NodeState nodeState) {
            return new PermissionStoreEditor(this.parentPath, nodeName, nodeState, PermissionHook.this.getPermissionRoot(this.parentPath), PermissionHook.this.isACE, PermissionHook.this.isGrantACE, PermissionHook.this.bitsProvider, PermissionHook.this.restrictionProvider, PermissionHook.this.providerCtx);
        }
    }
}

