/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.yellowpages.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.exception.UtilException;

public class GroupDAO {
    public static Collection<String> getGroupIds(Connection con, String fatherId, String instanceId) throws SQLException {
        ArrayList<String> groupIds = new ArrayList<String>();
        String query = "select groupId from SC_Contact_GroupFather where fatherId = ? and instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(fatherId));
            prepStmt.setString(2, instanceId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    String groupId = rs.getString(1);
                    groupIds.add(groupId);
                }
            }
        }
        return groupIds;
    }

    public static void addGroup(Connection con, String groupId, String fatherId, String instanceId) throws SQLException, UtilException {
        String query = "insert into SC_Contact_GroupFather values (?,?,?)";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(groupId));
            prepStmt.setInt(2, Integer.parseInt(fatherId));
            prepStmt.setString(3, instanceId);
            prepStmt.executeUpdate();
        }
    }

    public static void removeGroup(Connection con, String groupId) throws SQLException {
        String query = "delete from SC_Contact_GroupFather where groupId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(groupId));
            prepStmt.executeUpdate();
        }
    }

    public static void removeGroup(Connection con, String groupId, String fatherId, String instanceId) throws SQLException {
        String query = "delete from SC_Contact_GroupFather where groupId = ? and fatherId = ? and instanceId = ? ";
        try (PreparedStatement prepStmt = con.prepareStatement(query);){
            prepStmt.setInt(1, Integer.parseInt(groupId));
            prepStmt.setInt(2, Integer.parseInt(fatherId));
            prepStmt.setString(3, instanceId);
            prepStmt.executeUpdate();
        }
    }
}

