/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.repository;

import java.util.List;
import org.silverpeas.components.resourcesmanager.model.Resource;
import org.silverpeas.components.resourcesmanager.repository.ResourceRepository;
import org.silverpeas.core.annotation.Repository;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.repository.jpa.BasicJpaEntityRepository;

@Repository
public class ResourceJpaRepository
extends BasicJpaEntityRepository<Resource>
implements ResourceRepository {
    @Override
    public List<Resource> findAllResourcesByCategory(Long categoryId) {
        return this.listFromNamedQuery("resource.findAllResourcesByCategory", this.newNamedParameters().add("categoryId", (Object)UniqueLongIdentifier.from((long)categoryId)));
    }

    @Override
    public List<Resource> findAllBookableResources(String instanceId) {
        return this.listFromNamedQuery("resource.findAllBookableResources", this.newNamedParameters().add("instanceId", (Object)instanceId));
    }

    @Override
    public List<Resource> findAllResources(String instanceId) {
        return this.listFromNamedQuery("resource.findAllResources", this.newNamedParameters().add("instanceId", (Object)instanceId));
    }

    @Override
    public List<Resource> findAllResourcesForReservation(Long reservationId) {
        return this.listFromNamedQuery("reservedResource.findAllResourcesForReservation", this.newNamedParameters().add("reservationId", (Object)reservationId));
    }

    @Override
    public List<Resource> findAllReservedResources(Long reservationIdToSkip, List<Long> aimedResourceIds, String startPeriod, String endPeriod) {
        return this.listFromNamedQuery("reservedResource.findAllReservedResources", this.newNamedParameters().add("reservationIdToSkip", (Object)UniqueLongIdentifier.from((long)reservationIdToSkip)).add("aimedResourceIds", aimedResourceIds).add("startPeriod", (Object)startPeriod).add("endPeriod", (Object)endPeriod));
    }

    @Override
    public void deleteResourcesFromCategory(Long categoryId) {
        this.deleteFromNamedQuery("resource.deleteResourcesFromCategory", this.newNamedParameters().add("categoryId", (Object)UniqueLongIdentifier.from((long)categoryId)));
    }
}

