/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.function.Consumer;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.util.SafeEncode;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.jetbrains.annotations.NotNull;

public class LoggingHook
implements CommitHook,
NodeStateDiff {
    private final Consumer<String> writer;

    private LoggingHook(Consumer<String> writer) {
        this.writer = writer;
    }

    static LoggingHook newLoggingHook(Consumer<String> writer) {
        return new LoggingHook(writer);
    }

    public void enter(NodeState before, NodeState after) {
    }

    public void leave(NodeState before, NodeState after) {
        this.writer.accept("n!");
    }

    public boolean propertyAdded(PropertyState after) {
        this.writer.accept("p+ " + LoggingHook.toString(after));
        return true;
    }

    public boolean propertyChanged(PropertyState before, PropertyState after) {
        this.writer.accept("p^ " + LoggingHook.toString(after));
        return true;
    }

    public boolean propertyDeleted(PropertyState before) {
        this.writer.accept("p- " + LoggingHook.toString(before));
        return true;
    }

    private static String safeEncode(String value) {
        try {
            return SafeEncode.safeEncode(value);
        }
        catch (UnsupportedEncodingException e) {
            return "ERROR: " + e;
        }
    }

    public boolean childNodeAdded(String name, NodeState after) {
        this.writer.accept("n+ " + LoggingHook.safeEncode(name));
        this.enter(null, after);
        boolean ret = after.compareAgainstBaseState(EmptyNodeState.EMPTY_NODE, (NodeStateDiff)this);
        this.leave(null, after);
        return ret;
    }

    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        this.writer.accept("n^ " + LoggingHook.safeEncode(name));
        this.enter(before, after);
        boolean ret = after.compareAgainstBaseState(before, (NodeStateDiff)this);
        this.leave(before, after);
        return ret;
    }

    public boolean childNodeDeleted(String name, NodeState before) {
        this.writer.accept("n- " + LoggingHook.safeEncode(name));
        return true;
    }

    private static String toString(PropertyState ps) {
        StringBuilder val = new StringBuilder();
        val.append(LoggingHook.safeEncode(ps.getName()));
        val.append(" <");
        val.append(ps.getType());
        val.append("> ");
        if (ps.getType() == Type.BINARY) {
            val.append("= ");
            Blob blob = (Blob)ps.getValue(Type.BINARY);
            LoggingHook.appendBlob(val, blob);
        } else if (ps.getType() == Type.BINARIES) {
            val.append("= [");
            ((Iterable)ps.getValue(Type.BINARIES)).forEach(b -> {
                LoggingHook.appendBlob(val, b);
                val.append(',');
            });
            LoggingHook.replaceOrAppendLastChar(val, ',', ']');
        } else if (ps.isArray()) {
            val.append("= [");
            ((Iterable)ps.getValue(Type.STRINGS)).forEach(s -> {
                val.append(LoggingHook.safeEncode(s));
                val.append(',');
            });
            LoggingHook.replaceOrAppendLastChar(val, ',', ']');
        } else {
            val.append("= ").append(LoggingHook.safeEncode((String)ps.getValue(Type.STRING)));
        }
        return val.toString();
    }

    private static void replaceOrAppendLastChar(StringBuilder b, char oldChar, char newChar) {
        if (b.charAt(b.length() - 1) == oldChar) {
            b.setCharAt(b.length() - 1, newChar);
        } else {
            b.append(newChar);
        }
    }

    private static void appendBlob(StringBuilder sb, Blob blob) {
        InputStream is = blob.getNewStream();
        char[] hex = "0123456789ABCDEF".toCharArray();
        try {
            int b;
            while ((b = is.read()) >= 0) {
                sb.append(hex[b >> 4]);
                sb.append(hex[b & 0xF]);
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @NotNull
    public NodeState processCommit(NodeState before, NodeState after, CommitInfo info) {
        this.enter(before, after);
        after.compareAgainstBaseState(before, (NodeStateDiff)this);
        this.leave(before, after);
        return after;
    }
}

