/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import com.google.common.collect.AbstractIterator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BurnOnCloseFileIterator<T>
implements Closeable,
Iterator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BurnOnCloseFileIterator.class);
    private final Impl<T> delegate;

    public BurnOnCloseFileIterator(Iterator<String> iterator, Function<String, T> transformer) {
        this.delegate = new Impl<T>(iterator, null, transformer);
    }

    public BurnOnCloseFileIterator(Iterator<String> iterator, File backingFile, Function<String, T> transformer) {
        this.delegate = new Impl<T>(iterator, backingFile, transformer);
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public T next() {
        return (T)this.delegate.next();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public static BurnOnCloseFileIterator<String> wrap(Iterator<String> iter) {
        return new BurnOnCloseFileIterator<String>(iter, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        });
    }

    public static BurnOnCloseFileIterator<String> wrap(Iterator<String> iter, File backingFile) {
        return new BurnOnCloseFileIterator<String>(iter, backingFile, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return s;
            }
        });
    }

    private static class Impl<T>
    extends AbstractIterator<T>
    implements Closeable {
        private final Iterator<String> iterator;
        private final Function<String, T> transformer;
        private final File backingFile;

        public Impl(Iterator<String> iterator, File backingFile, Function<String, T> transformer) {
            this.iterator = iterator;
            this.transformer = transformer;
            this.backingFile = backingFile;
        }

        protected T computeNext() {
            if (this.iterator.hasNext()) {
                return this.transformer.apply(this.iterator.next());
            }
            try {
                this.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing iterator", (Throwable)e);
            }
            return (T)this.endOfData();
        }

        @Override
        public void close() throws IOException {
            if (this.iterator instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Object)this.iterator));
            }
            if (this.backingFile != null && this.backingFile.exists()) {
                FileUtils.forceDelete((File)this.backingFile);
            }
        }
    }
}

