/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.security.principal.PrincipalIterator;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Impersonation;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableImpl;
import org.apache.jackrabbit.oak.security.user.autosave.AutoSaveEnabledManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserImpl
extends AuthorizableImpl
implements User {
    UserImpl(User dlg, AutoSaveEnabledManager mgr) {
        super((Authorizable)dlg, mgr);
    }

    private User getDelegate() {
        return (User)this.getDlg();
    }

    public boolean isAdmin() {
        return this.getDelegate().isAdmin();
    }

    public boolean isSystemUser() {
        return this.getDelegate().isSystemUser();
    }

    @NotNull
    public Credentials getCredentials() throws RepositoryException {
        return this.getDelegate().getCredentials();
    }

    @NotNull
    public Impersonation getImpersonation() throws RepositoryException {
        return new ImpersonationImpl(this.getDelegate().getImpersonation());
    }

    public void changePassword(@Nullable String pw) throws RepositoryException {
        try {
            this.getDelegate().changePassword(pw);
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public void changePassword(@Nullable String pw, @NotNull String oldPw) throws RepositoryException {
        try {
            this.getDelegate().changePassword(pw, oldPw);
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public void disable(@Nullable String msg) throws RepositoryException {
        try {
            this.getDelegate().disable(msg);
        }
        finally {
            this.getMgr().autosave();
        }
    }

    public boolean isDisabled() throws RepositoryException {
        return this.getDelegate().isDisabled();
    }

    @Nullable
    public String getDisabledReason() throws RepositoryException {
        return this.getDelegate().getDisabledReason();
    }

    private final class ImpersonationImpl
    implements Impersonation {
        private final Impersonation dlg;

        private ImpersonationImpl(Impersonation dlg) {
            this.dlg = dlg;
        }

        @NotNull
        public PrincipalIterator getImpersonators() throws RepositoryException {
            return this.dlg.getImpersonators();
        }

        public boolean grantImpersonation(@NotNull Principal principal) throws RepositoryException {
            try {
                boolean bl = this.dlg.grantImpersonation(principal);
                return bl;
            }
            finally {
                UserImpl.this.getMgr().autosave();
            }
        }

        public boolean revokeImpersonation(@NotNull Principal principal) throws RepositoryException {
            try {
                boolean bl = this.dlg.revokeImpersonation(principal);
                return bl;
            }
            finally {
                UserImpl.this.getMgr().autosave();
            }
        }

        public boolean allows(@NotNull Subject subject) throws RepositoryException {
            return this.dlg.allows(subject);
        }
    }
}

