/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.accesscontrol;

import java.security.Principal;
import java.util.Set;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.security.authorization.accesscontrol.ACL;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.ACE;
import org.apache.jackrabbit.oak.spi.security.authorization.accesscontrol.AccessControlConstants;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalImpl;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class Util
implements AccessControlConstants {
    private Util() {
    }

    @NotNull
    static Principal checkValidPrincipal(@Nullable Principal principal) throws AccessControlException {
        String name;
        String string = name = principal == null ? null : principal.getName();
        if (name == null || name.isEmpty()) {
            throw new AccessControlException("Invalid principal " + name);
        }
        return principal;
    }

    static boolean checkValidPrincipal(@NotNull Principal principal, @NotNull PrincipalManager principalManager, int importBehavior) throws AccessControlException {
        String name = Util.checkValidPrincipal(principal).getName();
        if (importBehavior == 2) {
            return true;
        }
        if (!(principal instanceof PrincipalImpl) && !principalManager.hasPrincipal(name)) {
            switch (importBehavior) {
                case 3: {
                    throw new AccessControlException("Unknown principal " + name);
                }
                case 1: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Invalid import behavior " + importBehavior);
        }
        return true;
    }

    static boolean checkValidPrincipals(@Nullable Set<Principal> principals, @NotNull PrincipalManager principalManager, int importBehavior) throws AccessControlException {
        if (principals == null) {
            throw new AccessControlException("Valid principals expected. Found null.");
        }
        boolean isValid = false;
        for (Principal principal : principals) {
            if (principal == null) {
                throw new AccessControlException("Valid principal expected. Found null.");
            }
            isValid = Util.checkValidPrincipal(principal, principalManager, importBehavior);
        }
        return isValid;
    }

    static boolean isValidPolicy(@Nullable String oakPath, @NotNull AccessControlPolicy policy) {
        if (policy instanceof ACL) {
            String path = ((ACL)policy).getOakPath();
            return !(path == null && oakPath != null || path != null && !path.equals(oakPath));
        }
        return false;
    }

    static void checkValidPolicy(@Nullable String oakPath, @NotNull AccessControlPolicy policy) throws AccessControlException {
        if (!Util.isValidPolicy(oakPath, policy)) {
            throw new AccessControlException("Invalid access control policy " + policy);
        }
    }

    static boolean isAccessControlled(@Nullable String oakPath, @NotNull Tree tree, @NotNull ReadOnlyNodeTypeManager ntMgr) {
        String mixinName = Util.getMixinName(oakPath);
        return ntMgr.isNodeType(tree, mixinName);
    }

    static boolean isACE(@NotNull Tree tree, @NotNull ReadOnlyNodeTypeManager ntMgr) {
        return tree.exists() && ntMgr.isNodeType(tree, "rep:ACE");
    }

    @NotNull
    static String getMixinName(@Nullable String oakPath) {
        return oakPath == null ? "rep:RepoAccessControllable" : "rep:AccessControllable";
    }

    @NotNull
    static String getAclName(@Nullable String oakPath) {
        return oakPath == null ? "rep:repoPolicy" : "rep:policy";
    }

    @NotNull
    static String generateAceName(@NotNull ACE ace, int index) {
        String hint;
        String string = hint = ace.isAllow() ? "allow" : "deny";
        if (index == 0) {
            return hint;
        }
        return hint + index;
    }

    static int getImportBehavior(AuthorizationConfiguration config) {
        String importBehaviorStr = (String)config.getParameters().getConfigValue("importBehavior", (Object)"abort");
        return ImportBehavior.valueFromString((String)importBehaviorStr);
    }
}

