/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Set;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.Filter;

public class ChildNodeJoinConditionImpl
extends JoinConditionImpl {
    private final String childSelectorName;
    private final String parentSelectorName;
    private SelectorImpl childSelector;
    private SelectorImpl parentSelector;

    public ChildNodeJoinConditionImpl(String childSelectorName, String parentSelectorName) {
        this.childSelectorName = childSelectorName;
        this.parentSelectorName = parentSelectorName;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return "ischildnode(" + this.quote(this.childSelectorName) + ", " + this.quote(this.parentSelectorName) + ")";
    }

    public void bindSelector(SourceImpl source) {
        this.parentSelector = source.getExistingSelector(this.parentSelectorName);
        this.childSelector = source.getExistingSelector(this.childSelectorName);
    }

    @Override
    public boolean evaluate() {
        String p = this.parentSelector.currentPath();
        String c = this.childSelector.currentPath();
        return !PathUtils.denotesRoot((String)c) && PathUtils.getParentPath((String)c).equals(p);
    }

    @Override
    public void restrict(FilterImpl f) {
        if (f.getSelector().equals(this.parentSelector)) {
            String c = this.childSelector.currentPath();
            if (c == null && f.isPreparing() && f.isPrepared(this.childSelector)) {
                f.restrictPath("//parent/of/join", Filter.PathRestriction.EXACT);
            } else if (c != null) {
                f.restrictPath(PathUtils.getParentPath((String)c), Filter.PathRestriction.EXACT);
            }
        }
        if (f.getSelector().equals(this.childSelector)) {
            String p = this.parentSelector.currentPath();
            if (p == null && f.isPreparing() && f.isPrepared(this.parentSelector)) {
                f.restrictPath("//path/from/join", Filter.PathRestriction.DIRECT_CHILDREN);
            } else if (p != null) {
                f.restrictPath(p, Filter.PathRestriction.DIRECT_CHILDREN);
            }
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
    }

    @Override
    public boolean isParent(SourceImpl source) {
        return source.equals(this.parentSelector);
    }

    @Override
    public boolean canEvaluate(Set<SourceImpl> available) {
        return available.contains(this.childSelector) && available.contains(this.parentSelector);
    }

    @Override
    public AstElement copyOf() {
        return new ChildNodeJoinConditionImpl(this.childSelectorName, this.parentSelectorName);
    }
}

