/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.QueryImpl;
import org.apache.jackrabbit.oak.query.ast.AstElement;
import org.apache.jackrabbit.oak.query.ast.AstElementFactory;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.NotImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;

public class AndImpl
extends ConstraintImpl {
    private final List<ConstraintImpl> constraints;

    public AndImpl(List<ConstraintImpl> constraints) {
        Preconditions.checkArgument((!constraints.isEmpty() ? 1 : 0) != 0);
        this.constraints = constraints;
    }

    public AndImpl(ConstraintImpl constraint1, ConstraintImpl constraint2) {
        this(Arrays.asList(constraint1, constraint2));
    }

    public List<ConstraintImpl> getConstraints() {
        return this.constraints;
    }

    @Override
    public ConstraintImpl simplify() {
        LinkedHashSet simplified = Sets.newLinkedHashSet();
        boolean changed = false;
        for (ConstraintImpl constraint : this.constraints) {
            ConstraintImpl simple = constraint.simplify();
            if (simple instanceof AndImpl) {
                simplified.addAll(((AndImpl)simple).constraints);
                changed = true;
                continue;
            }
            if (simplified.add(simple)) {
                changed = changed || simple != constraint;
                continue;
            }
            changed = true;
        }
        if (simplified.size() == 1) {
            return (ConstraintImpl)simplified.iterator().next();
        }
        if (changed) {
            return new AndImpl(Lists.newArrayList((Iterable)simplified));
        }
        return this;
    }

    @Override
    ConstraintImpl not() {
        ArrayList list = Lists.newArrayList();
        for (ConstraintImpl constraint : this.constraints) {
            list.add(new NotImpl(constraint));
        }
        return new OrImpl(list).simplify();
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        HashSet result = Sets.newHashSet();
        for (ConstraintImpl constraint : this.constraints) {
            result.addAll(constraint.getPropertyExistenceConditions());
        }
        return result;
    }

    @Override
    public FullTextExpression getFullTextConstraint(SelectorImpl s) {
        ArrayList list = Lists.newArrayList();
        for (ConstraintImpl constraint : this.constraints) {
            FullTextExpression expression = constraint.getFullTextConstraint(s);
            if (expression == null) continue;
            list.add(expression);
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (FullTextExpression)list.iterator().next();
            }
        }
        return new FullTextAnd((List)list);
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        HashSet result = Sets.newHashSet();
        for (ConstraintImpl constraint : this.constraints) {
            result.addAll(constraint.getSelectors());
        }
        return result;
    }

    @Override
    public boolean evaluate() {
        for (ConstraintImpl constraint : this.constraints) {
            if (constraint.evaluate()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateStop() {
        for (ConstraintImpl constraint : this.constraints) {
            if (!constraint.evaluateStop()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    @Override
    public void restrict(FilterImpl f) {
        for (ConstraintImpl constraint : this.constraints) {
            constraint.restrict(f);
        }
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        for (ConstraintImpl constraint : this.constraints) {
            constraint.restrictPushDown(s);
        }
    }

    public String toString() {
        if (this.constraints.size() == 1) {
            return this.constraints.iterator().next().toString();
        }
        StringBuilder builder = new StringBuilder();
        for (ConstraintImpl constraint : this.constraints) {
            if (builder.length() > 0) {
                builder.append(" and ");
            }
            builder.append(this.protect(constraint));
        }
        return builder.toString();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof AndImpl) {
            return this.constraints.equals(((AndImpl)that).constraints);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.constraints.hashCode();
    }

    @Override
    public AstElement copyOf() {
        ArrayList<ConstraintImpl> clone = new ArrayList<ConstraintImpl>(this.constraints.size());
        for (ConstraintImpl c : this.constraints) {
            clone.add((ConstraintImpl)AstElementFactory.copyElementAndCheckReference(c));
        }
        return new AndImpl(clone);
    }

    public void addToUnionList(Set<ConstraintImpl> target) {
        AndImpl and = this.pullOrRight();
        ConstraintImpl last = and.getLastConstraint();
        if (last instanceof OrImpl) {
            OrImpl or = (OrImpl)last;
            for (ConstraintImpl c : or.getConstraints()) {
                ArrayList<ConstraintImpl> list = and.getFirstConstraints();
                list.add(c);
                new AndImpl(list).addToUnionList(target);
            }
            return;
        }
        target.add(this);
    }

    private ArrayList<ConstraintImpl> getFirstConstraints() {
        ArrayList<ConstraintImpl> list = new ArrayList<ConstraintImpl>(this.constraints.size() - 1);
        list.addAll(this.constraints.subList(0, this.constraints.size() - 1));
        return list;
    }

    private ConstraintImpl getLastConstraint() {
        return this.constraints.get(this.constraints.size() - 1);
    }

    public AndImpl pullOrRight() {
        if (this.getLastConstraint() instanceof OrImpl) {
            return this;
        }
        ArrayList<ConstraintImpl> andList = this.getAllAndConditions();
        for (int i = 0; i < andList.size() - 1; ++i) {
            ConstraintImpl c = andList.get(i);
            if (!(c instanceof OrImpl)) continue;
            ArrayList<ConstraintImpl> list = new ArrayList<ConstraintImpl>();
            list.addAll(andList);
            list.remove(i);
            list.add(c);
            return new AndImpl(list);
        }
        return this;
    }

    private ArrayList<ConstraintImpl> getAllAndConditions() {
        ArrayList<ConstraintImpl> list = new ArrayList<ConstraintImpl>();
        for (ConstraintImpl c : this.constraints) {
            if (c instanceof AndImpl) {
                list.addAll(((AndImpl)c).getAllAndConditions());
                continue;
            }
            list.add(c);
        }
        return list;
    }

    @Override
    public Set<ConstraintImpl> convertToUnion() {
        LinkedHashSet union = Sets.newLinkedHashSet();
        LinkedHashSet result = Sets.newLinkedHashSet();
        HashSet nonUnion = Sets.newHashSet();
        for (ConstraintImpl c : this.constraints) {
            Set<ConstraintImpl> converted = c.convertToUnion();
            if (converted.isEmpty()) {
                nonUnion.add(c);
                continue;
            }
            union.addAll(converted);
            if (union.size() <= QueryImpl.MAX_UNION) continue;
            throw QueryImpl.TOO_MANY_UNION;
        }
        if (!union.isEmpty() && nonUnion.size() == 1) {
            ConstraintImpl right = (ConstraintImpl)nonUnion.iterator().next();
            for (ConstraintImpl c : union) {
                result.add(new AndImpl(c, right));
            }
        } else if (QueryEngineSettings.SQL2_OPTIMIZATION_2) {
            LinkedHashSet set = Sets.newLinkedHashSet();
            this.addToUnionList(set);
            if (set.size() == 1) {
                return Collections.emptySet();
            }
            return set;
        }
        return result;
    }

    @Override
    public boolean requiresFullTextIndex() {
        for (ConstraintImpl c : this.constraints) {
            if (!c.requiresFullTextIndex()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUnfilteredFullTextCondition() {
        for (ConstraintImpl c : this.constraints) {
            if (!c.containsUnfilteredFullTextCondition()) continue;
            return true;
        }
        return false;
    }
}

